<?php

namespace App\Exports;

use App\Model\Registers;
use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class RegistersExport implements FromView
{
    public function view(): View
    {
        $registers = Registers::orderBy("created_at", "DESC")->get();
        if (empty($registers)) {
            abort(404);
        }

        if (isset($registers)) {
            foreach ($registers as $register) {
                $exp_phone = explode("-", $register->phone);
                $register->phone = implode("", $exp_phone);
            }
        }

        return view('exports.registers', [
            'registers' => $registers
        ]);
    }
}
?>