<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Request;
use Auth;
use Validator;
use Log;
use File;
use Storage;
use DB;
use Carbon\Carbon;
use Helper;
use App\Model\Brands;

class BrandsApiController extends Controller
{
    public function getBrandList(Request $request, $type = 1, $orderBy = 'order_by', $ascdesc = 'asc', $limit_page = 0, $keyword = '')
    {
        $query = Brands::query();

        if ($keyword != '') {
            $query = $query->searchKeyword($keyword);
        }

        $query = $query->orderBy($orderBy, $ascdesc);
        if ($limit_page == 0) {
            $result = $query->get();
        } else {
            $result = $query->paginate($limit_page);
        }

        if ($type == 1) {
            return response()->json(array('status' => 'success', 'data' => $result), 200);
        } else {
            return $result;
        }
    }

    public function getBrandListFront(Request $request)
    {
        $query = Brands::query();
        $query = $query->whereStatus("Active");
        $query = $query->orderBy("order_by", "ASC");
        $result = $query->get();
        return $result;
    }

    public function index(Request $request)
    {
        try {
            $query = Brands::query();
            if ($request->input('where') !== null) {
                $where = $request->input('where');
                foreach ($where as $key => $value) {
                    $field = $key;
                    $cond = key($value);
                    $var = pos($value);
                    if ($cond == 7)
                        $var = "%" . $var . "%";
    
                    $query = $query->where($field, config("config.config_arr_condition")[$cond], $var);
                }
            }
    
            if ($request->input('order') !== null) {
                $order = $request->input('order');
                foreach ($order as $key => $value) {
                    $query = $query->orderBy($key, $value);
                }
            }
    
            if ($request->input('filter') !== null) {
                $filter = $request->input('filter');
    
                if ($filter["limit"] !== null && $filter["limit"] != 0) {
                    $query = $query->take($filter["limit"]);
                }
                if ($filter["offset"] !== null && $filter["offset"] != 0) {
                    $query = $query->offset(($filter["offset"] - 1));
                }
                if ($filter["skip"] !== null && $filter["skip"] != 0) {
                    $query = $query->skip($filter["skip"]);
                }
            }
    
            $data = $query->get();
    
            return response()->json([
                "success" => true,
                "total" => sizeof($data),
                'data' => $data,
                "msg" => "Get data success"
            ], 200);
        } catch (Exception $e) {
            return response()->json(array('success' => false, 'data' => $e, "message" => "Get all data fail"), 404);
        }
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title_th' => 'required',
            'title_en' => 'required',
            // 'url' => 'required|url',
        ],
        [
            'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
            'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
            // 'url.required' => 'กรุณาใส่ลิงค์',
            // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
        ]);

        if ($validator->fails()) {
            //return $validation->errors();
            return response()->json([
                "success" => false,
                'data' => null,
                "msg" => $validator->errors()
            ], 422);
        } else {
            $ip_address = $request->ip();
            if ($request->ip() == "::1") {
                $ip_address = "127.0.0.1";
            }

            $now = Carbon::now();
            $current_datetime = $now->toDateTimeString();

            $startDate = ($request->input("startDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("startDate"))->format("Y-m-d") : NULL;
            $endDate = ($request->input("endDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("endDate"))->format("Y-m-d") : NULL;

            $status = ($request->input("status") !== null) ? $request->input("status") : "Inactive";
            $order_by = 0;
            $created_by = ($request->input("created_by") !== null) ? $request->input("created_by") : 0;
            $updated_by = ($request->input("updated_by") !== null) ? $request->input("updated_by") : 0;

            DB::beginTransaction();
            try {
                $brand = new Brands;
                $brand->url = $request->input("url");
                $brand->type = $request->input("type");
                $brand->title_th = $request->input("title_th");
                $brand->detail_th = $request->input("detail_th");
                $brand->content_th = $request->input("content_th");
                $brand->title_en = $request->input("title_en");
                $brand->detail_en = $request->input("detail_en");
                $brand->content_en = $request->input("content_en");
                $brand->startDate = $startDate;
                $brand->endDate = $endDate;
                $brand->visitor = $ip_address;
                $brand->status = $status;
                $brand->created_at = $current_datetime;
                $brand->updated_at = $current_datetime;
                $brand->created_by = $created_by;
                $brand->updated_by = $updated_by;
                $brand->order_by = $order_by;
                $brand->save();

                $query = Brands::query();
                $update_order = $query->increment("order_by");
                
                $data = array(
                    "brand" => $brand,
                );

                DB::commit();
                return response()->json(array('success' => true, 'data' => $data, "message" => "Successfully inserted"), 200);
            } catch (Exception $e) {
                DB::rollback();
                return response()->json(array('success' => false, 'data' => $e, "message" => "Inserted fail"), 404);
            }
        }
    }

    public function show($id)
    {
        $data = Brands::find($id);
        if (empty($data)) {
            return response()->json([
                "success" => false,
                'data' => "",
                "msg" => ""
            ], 402);
        } else {
            return response()->json([
                "success" => true,
                "total" => $data->count(),
                'data' => $data,
                "msg" => "Get data by id success"
            ], 200);
        }
    }

    public function update(Request $request, $brand_id = 0)
    {
        $validator = Validator::make($request->all(), [
            'title_th' => 'required',
            'title_en' => 'required',
            // 'url' => 'required|url',
        ],
        [
            'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
            'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
            // 'url.required' => 'กรุณาใส่ลิงค์',
            // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
        ]);

        if ($validator->fails()) {
            //return $validation->errors();
            return response()->json([
                "success" => false,
                'data' => null,
                "msg" => $validator->errors()
            ], 422);
        } else {

            $ip_address = $request->ip();
            if ($request->ip() == "::1") {
                $ip_address = "127.0.0.1";
            }

            $brand = Brands::find($brand_id);
            if (empty($brand)) {
                return response()->json(array('success' => false, 'data' => null, 'message' => 'No Data'), 200);
            }

            $now = Carbon::now();
            $current_datetime = $now->toDateTimeString();

            $startDate = ($request->input("startDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("startDate"))->format("Y-m-d") : $brand->startDate;
            $endDate = ($request->input("endDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("endDate"))->format("Y-m-d") : $brand->endDate;

            $status = ($request->input("status") !== null) ? $request->input("status") : $brand->status;
            $order_by = ($request->input("order_by") !== null) ? $request->input("order_by") : $brand->order_by;
            $created_by = ($request->input("created_by") !== null) ? $request->input("created_by") : 0;
            $updated_by = ($request->input("updated_by") !== null) ? $request->input("updated_by") : 0;

            DB::beginTransaction();
            try {
                $brand->url = $request->input("url");
                $brand->type = $request->input("type");
                $brand->title_th = $request->input("title_th");
                $brand->detail_th = $request->input("detail_th");
                $brand->content_th = $request->input("content_th");
                $brand->title_en = $request->input("title_en");
                $brand->detail_en = $request->input("detail_en");
                $brand->content_en = $request->input("content_en");
                $brand->startDate = $startDate;
                $brand->endDate = $endDate;
                $brand->visitor = $ip_address;
                $brand->status = $status;
                $brand->updated_at = $current_datetime;
                $brand->updated_by = $updated_by;
                $brand->order_by = $order_by;

                $brand->save();

                $data = array(
                    "brand" => $brand,
                );

                DB::commit();
                return response()->json(array('success' => true, 'data' => $data, "message" => "Successfully updated"), 200);
            } catch (Exception $e) {
                DB::rollback();
                return response()->json(array('success' => false, 'data' => $e, "message" => "Updated fail"), 404);
            }
        }
    }

    public function delete($id)
    {
        DB::beginTransaction();
        try {
            $brand = Brands::find($id);
            $brand->delete();

            $brands = Brands::orderBy("order_by","asc")->get();
            if ($brands && $brands->count() > 0) {
                foreach ($brands as $key => $value) {
                    $dataUpdate = array(
                        "order_by" => $key + 1,
                    );
                    $value->update($dataUpdate);
                }
            }

            $data = array(
                "id" => $id
            );

            DB::commit();
            return response()->json([
                "success" => true,
                'data' => $data,
                "msg" => "Brand - delete data success"
            ], 200);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                "success" => false,
                'data' => "",
                "msg" => "Brand - error"
            ], 502);
        }
    }
}
