<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Request;
use Auth;
use Validator;
use Log;
use File;
use Storage;
use DB;
use Carbon\Carbon;
use Helper;
use App\Model\Contents;

class ContentsApiController extends Controller
{
    public function getContentList(Request $request, $type = 1, $orderBy = 'order_by', $ascdesc = 'asc', $limit_page = 0, $keyword = '')
    {
        $query = Contents::query();

        if ($keyword != '') {
            $query = $query->searchKeyword($keyword);
        }

        $query = $query->orderBy($orderBy, $ascdesc);
        if ($limit_page == 0) {
            $result = $query->get();
        } else {
            $result = $query->paginate($limit_page);
        }

        if ($type == 1) {
            return response()->json(array('status' => 'success', 'data' => $result), 200);
        } else {
            return $result;
        }
    }

    public function getContentListFront(Request $request)
    {
        $query = Contents::query();
        $query = $query->whereStatus("Active");
        $query = $query->orderBy("order_by", "ASC");
        $result = $query->get();
        return $result;
    }

    public function index(Request $request)
    {
        try {
            $query = Contents::query();
            if ($request->input('where') !== null) {
                $where = $request->input('where');
                foreach ($where as $key => $value) {
                    $field = $key;
                    $cond = key($value);
                    $var = pos($value);
                    if ($cond == 7)
                        $var = "%" . $var . "%";
    
                    $query = $query->where($field, config("config.config_arr_condition")[$cond], $var);
                }
            }
    
            if ($request->input('order') !== null) {
                $order = $request->input('order');
                foreach ($order as $key => $value) {
                    $query = $query->orderBy($key, $value);
                }
            }
    
            if ($request->input('filter') !== null) {
                $filter = $request->input('filter');
    
                if ($filter["limit"] !== null && $filter["limit"] != 0) {
                    $query = $query->take($filter["limit"]);
                }
                if ($filter["offset"] !== null && $filter["offset"] != 0) {
                    $query = $query->offset(($filter["offset"] - 1));
                }
                if ($filter["skip"] !== null && $filter["skip"] != 0) {
                    $query = $query->skip($filter["skip"]);
                }
            }
    
            $data = $query->get();
    
            return response()->json([
                "success" => true,
                "total" => sizeof($data),
                'data' => $data,
                "msg" => "Get data success"
            ], 200);
        } catch (Exception $e) {
            return response()->json(array('success' => false, 'data' => $e, "message" => "Get all data fail"), 404);
        }
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "thumb" => 'mimes:jpg,jpeg,png|max:10000',
            'title_th' => 'required',
            'title_en' => 'required',
            // 'url' => 'required|url',
        ],
        [
            'thumb.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
            'thumb.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
            'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
            'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
            // 'url.required' => 'กรุณาใส่ลิงค์',
            // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
        ]);

        if ($validator->fails()) {
            //return $validation->errors();
            return response()->json([
                "success" => false,
                'data' => null,
                "msg" => $validator->errors()
            ], 422);
        } else {
            $ip_address = $request->ip();
            if ($request->ip() == "::1") {
                $ip_address = "127.0.0.1";
            }

            $now = Carbon::now();
            $current_datetime = $now->toDateTimeString();

            $pathDate = $now->format("Y/m");
            $filenametostore = "";

            if ($request->hasFile('thumb')) {
                $pathFile = config('config.config_pathUpload') . '/contents/' . $pathDate;
                File::isDirectory($pathDate) or File::makeDirectory($pathFile, 0777, true, true);
                $filenametostore = $filename_thumb_th = 'thumb-' . time() . '.' . str_replace(" ", "_", $request->thumb->getClientOriginalName());
                Helper::storageProcess("save", $pathFile, $filenametostore, $request->file('thumb'));
            }

            // $startDate = ($request->input("startDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("startDate"))->format("Y-m-d") : NULL;
            // $endDate = ($request->input("endDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("endDate"))->format("Y-m-d") : NULL;

            $status = ($request->input("status") !== null) ? $request->input("status") : "Inactive";
            $order_by = 0;
            $created_by = ($request->input("created_by") !== null) ? $request->input("created_by") : 0;
            $updated_by = ($request->input("updated_by") !== null) ? $request->input("updated_by") : 0;

            DB::beginTransaction();
            try {
                $content = new Contents;
                $content->thumb = $filenametostore;
                // $content->url = $request->input("url");
                $content->title_th = $request->input("title_th");
                $content->detail_th = $request->input("detail_th");
                // $content->weight_th = $request->input("weight_th");
                $content->title_en = $request->input("title_en");
                $content->detail_en = $request->input("detail_en");
                $content->content = $request->input("contentHtml");
                // $content->weight_en = $request->input("weight_en");
                // $content->startDate = $startDate;
                // $content->endDate = $endDate;
                $content->visitor = $ip_address;
                $content->status = $status;
                $content->created_at = $current_datetime;
                $content->updated_at = $current_datetime;
                $content->created_by = $created_by;
                $content->updated_by = $updated_by;
                $content->order_by = $order_by;
                $content->save();

                $query = Contents::query();
                $update_order = $query->increment("order_by");
                
                $data = array(
                    "content" => $content,
                );

                DB::commit();
                return response()->json(array('success' => true, 'data' => $data, "message" => "Successfully inserted"), 200);
            } catch (Exception $e) {
                DB::rollback();
                return response()->json(array('success' => false, 'data' => $e, "message" => "Inserted fail"), 404);
            }
        }
    }

    public function show($id)
    {
        $data = Contents::find($id);
        if (empty($data)) {
            return response()->json([
                "success" => false,
                'data' => "",
                "msg" => ""
            ], 402);
        } else {
            return response()->json([
                "success" => true,
                "total" => $data->count(),
                'data' => $data,
                "msg" => "Get data by id success"
            ], 200);
        }
    }

    public function update(Request $request, $content_id = 0)
    {
        $validator = Validator::make($request->all(), [
            "thumb" => 'mimes:jpg,jpeg,png|max:10000',
            'title_th' => 'required',
            'title_en' => 'required',
            // 'url' => 'required|url',
        ],
        [
            'thumb.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
            'thumb.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
            'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
            'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
            // 'url.required' => 'กรุณาใส่ลิงค์',
            // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
        ]);

        if ($validator->fails()) {
            //return $validation->errors();
            return response()->json([
                "success" => false,
                'data' => null,
                "msg" => $validator->errors()
            ], 422);
        } else {

            $ip_address = $request->ip();
            if ($request->ip() == "::1") {
                $ip_address = "127.0.0.1";
            }

            $content = Contents::find($content_id);
            if (empty($content)) {
                return response()->json(array('success' => false, 'data' => null, 'message' => 'No Data'), 200);
            }

            $now = Carbon::now();
            $current_datetime = $now->toDateTimeString();

            $pathDate = Carbon::parse($content->created_at)->format("Y/m");
            $filenametostore = $content->thumb;
            $pathFile = config('config.config_pathUpload') . '/contents/' . $pathDate;

            if ($request->action_thumb=="delete")
            {
                $responDelete = Helper::storageProcess("delete", $pathFile, $filenametostore);
                $filenametostore = "";
            }

            if ($request->hasFile('thumb')) {
                File::isDirectory($pathDate) or File::makeDirectory($pathFile, 0777, true, true);
                $new_filenametostore = 'thumb-' . time() . '.' . str_replace(" ", "_", $request->thumb->getClientOriginalName());

                $responUpload = Helper::storageProcess("save", $pathFile, $new_filenametostore, $request->file('thumb'));
                if ($responUpload)
                {
                    $responDelete = Helper::storageProcess("delete", $pathFile, $filenametostore);
                    $filenametostore = $new_filenametostore;
                }
            }

            // $startDate = ($request->input("startDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("startDate"))->format("Y-m-d") : $content->startDate;
            // $endDate = ($request->input("endDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("endDate"))->format("Y-m-d") : $content->endDate;

            $status = ($request->input("status") !== null) ? $request->input("status") : $content->status;
            $order_by = ($request->input("order_by") !== null) ? $request->input("order_by") : $content->order_by;
            $created_by = ($request->input("created_by") !== null) ? $request->input("created_by") : 0;
            $updated_by = ($request->input("updated_by") !== null) ? $request->input("updated_by") : 0;

            DB::beginTransaction();
            try {
                $content->thumb = $filenametostore;
                // $content->url = $request->input("url");
                $content->title_th = $request->input("title_th");
                $content->detail_th = $request->input("detail_th");
                // $content->weight_th = $request->input("weight_th");
                $content->title_en = $request->input("title_en");
                $content->detail_en = $request->input("detail_en");
                $content->content = $request->input("contentHtml");
                // $content->weight_en = $request->input("weight_en");
                // $content->startDate = $startDate;
                // $content->endDate = $endDate;
                $content->visitor = $ip_address;
                $content->status = $status;
                $content->updated_at = $current_datetime;
                $content->updated_by = $updated_by;
                $content->order_by = $order_by;

                $content->save();

                $data = array(
                    "content" => $content,
                );

                DB::commit();
                return response()->json(array('success' => true, 'data' => $data, "message" => "Successfully updated"), 200);
            } catch (Exception $e) {
                DB::rollback();
                return response()->json(array('success' => false, 'data' => $e, "message" => "Updated fail"), 404);
            }
        }
    }

    public function delete($id)
    {
        DB::beginTransaction();
        try {
            $content = Contents::find($id);

            $pathDate = Carbon::parse($content->created_at)->format("Y/m");
            $filenametostore = $content->thumb;
            $pathFile = config('config.config_pathUpload') . '/contents/' . $pathDate;
            $responDelete = Helper::storageProcess("delete", $pathFile, $filenametostore);

            $content->delete();

            $contents = Contents::orderBy("order_by","asc")->get();
            if ($contents && $contents->count() > 0) {
                foreach ($contents as $key => $value) {
                    $dataUpdate = array(
                        "order_by" => $key + 1,
                    );
                    $value->update($dataUpdate);
                }
            }

            $data = array(
                "id" => $id
            );

            DB::commit();
            return response()->json([
                "success" => true,
                'data' => $data,
                "msg" => "Content - delete data success"
            ], 200);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                "success" => false,
                'data' => "",
                "msg" => "Content - error"
            ], 502);
        }
    }
}
