<?php

namespace App\Http\Controllers\Api;

use App\Http\Classes\Helper;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Model\Functions\Functionphp;
use File;
use App\Model\NewViews;
use App\Model\PolicyViews;
use App\Model\ProcedureViews;
use App\Model\FormViews;
use App\Http\Controllers\Api\NewsApiController;
use App\Http\Controllers\Api\PolicysApiController;
use App\Http\Controllers\Api\ProceduresApiController;
use App\Http\Controllers\Api\FormsApiController;


class ProcessApiController extends Controller
{
    public static function deleteItem(Request $request)
    {
        $table = $request->table;
        $content_id = $request->content_id;
        $field = $request->field;

        $result = DB::table($table)->where($field,$content_id)->first();
        if (!empty($result))
        {
            $pathFile = Functionphp::php_convertDateToPathFile($news->created_at);
            Helper::storageProcess("delete",$pathFile,$result->filename);

            $delete = DB::table($table)->where($field,$content_id)->delete();
        }
        else
        {
            return response()->json(array('status' => "nodata", 'message' => 'Delete form fail'), 200);
        }
        
        if ($delete===NULL)
            return response()->json(array('status' => "fail", 'message' => 'Delete form fail'), 404);
        else
            return response()->json(array('status' => "success", 'message' => 'Delete form success'), 200);
    }


    public static function clickDownloadPDF(Request $request)
    {
        $table = $request->table;
        $content_id = $request->content_id;
        
        $ip_address = $request->ip();
        if ($request->ip()=="::1")
            $ip_address = "127.0.0.1";

        $now = Carbon::now();
        $current_datetime = $now->toDateTimeString();
        
        if ($table=="new_views")
            $content_views = new NewViews;
        else if ($table=="policy_views")
            $content_views = new PolicyViews; 
        else if ($table=="procedure_views")
            $content_views = new ProcedureViews;
        else if ($table=="form_views")
            $content_views = new FormViews;
        
        $content_views->type = 2;
        $content_views->content_id = $content_id;
        $content_views->visitor = $ip_address;
        $content_views->created_at = $current_datetime;
        $content_views->updated_at = $current_datetime;
        $content_views->save();

        return response()->json(array('success' => true, 'message' => 'count download success'), 200);
    }

    public static function comment(Request $request)
    {
        $table = $request->table;
        $request->status = "N";

        $now = Carbon::now();
        $current_datetime = $now->toDateTimeString();
        
        if ($table=="news")
        {
            $comment = new NewsApiController;
            $request->news_id = $request->refer_id;
        }
        else if ($table=="policys")
        {
            $comment = new PolicysApiController; 
            $request->policys_id = $request->refer_id;
        }
        else if ($table=="procedures")
        {
            $comment = new ProceduresApiController;
            $request->procedures_id = $request->refer_id;
        }
        else if ($table=="forms")
        {
            $comment = new FormsApiController;
            $request->forms_id = $request->refer_id;
        }

        $result_comment = $comment->storeComment($request);

        return $result_comment;
    }


    public static function vote(Request $request)
    {
        $table = $request->table;

        $now = Carbon::now();
        $current_datetime = $now->toDateTimeString();
        
        if ($table=="news")
        {
            $vote = new NewsApiController;
        }
        else if ($table=="policys")
        {
            $vote = new PolicysApiController;
        }
        else if ($table=="procedures")
        {
            $vote = new ProceduresApiController;
        }
        else if ($table=="forms")
        {
            $vote = new FormsApiController;
        }

        $result_vote = $vote->storeVoteScore($request);

        return $result_vote;
    }


    public static function getTestDepartments(Request $request)
    {
        $data = array(
            array(
                "id"=>1,
                "name"=>"Sales",
                "nameTH"=>"ขาย"
            ),
            array(
                "id"=>2,
                "name"=>"Technology",
                "nameTH"=>"เทคโนโลยี"
            ),
            array(
                "id"=>3,
                "name"=>"Human Resources",
                "nameTH"=>"ทรัพยากรบุคคล"
            ),
        );

        return response()->json(array('success' => true, 'message' => 'Departments','data'=>$data), 200);
    }


    public static function getTestStaffs(Request $request)
    {
        $data = array(
            array(
                "employee_id" => "1",
                "sAMAccountName" => "testSaleManager",
                "givenNameTH" => "ทอทหาร",
                "snTH" => "อดทน",
                "givenName" => "Soldier",
                "sn" => "patient",
                "titleTH" => "ผู้จัดการฝ่ายขาย",
                "title" => "sale manager",
                "email" => "soldier@allinspire.co.th",
                "mobile" => "0892223333",
                "physicalDeliveryOfficeName" => "024445555",
                "ipPhone" => "1234",
                "level" => "1",
                "children" => array(

                    /*level 2*/
                    array(
                        "employee_id" => "2",
                        "sAMAccountName" => "testSaleVicePresidentA",
                        "givenNameTH" => "มานี",
                        "snTH" => "มีหม้อ",
                        "givenName" => "Mane",
                        "sn" => "Pot",
                        "titleTH" => "รองผู้จัดการฝ่ายขาย A",
                        "title" => "Vice President of Sales A",
                        "email" => "mane@allinspire.co.th",
                        "mobile" => "0841237777",
                        "physicalDeliveryOfficeName" => "025556666",
                        "ipPhone" => "5678",
                        "level" => "2",
                        "children" => array(

                            /*level3*/
                            array(
                                "employee_id" => "3",
                                "sAMAccountName" => "testStaffA1",
                                "givenNameTH" => "มานะ",
                                "snTH" => "พากเพียร",
                                "givenName" => "Mana",
                                "sn" => "dogged",
                                "titleTH" => "พนักงานทีม A1",
                                "title" => "Staff A1",
                                "email" => "Mana@allinspire.co.th",
                                "mobile" => "0868889999",
                                "physicalDeliveryOfficeName" => "026667777",
                                "ipPhone" => "9999",
                                "level" => "3"
                            )
                            /*level3*/

                        )
                        //children
                    ),
                    array(
                        "employee_id" => "4",
                        "sAMAccountName" => "testSaleVicePresidentB1",
                        "givenNameTH" => "แดง",
                        "snTH" => "ใบเล่",
                        "givenName" => "Red",
                        "sn" => "Bile",
                        "titleTH" => "รองผู้จัดการฝ่ายขาย B",
                        "title" => "Vice President of Sales B",
                        "email" => "red@allinspire.co.th",
                        "mobile" => "0913334444",
                        "physicalDeliveryOfficeName" => "028889999",
                        "ipPhone" => "1111",
                        "level" => "2"
                    )
                    /*level 2*/
                )
            )
        );

        return response()->json(array('success' => true, 'message' => 'Departments','data'=>$data), 200);
    }
}
