<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Request;
use Auth;
use Validator;
use Log;
use File;
use Storage;
use DB;
use Carbon\Carbon;
use Helper;
use App\Model\Products;
use Illuminate\Support\Str;

class ProductsApiController extends Controller
{
    public function getProductList(Request $request, $type = 1, $orderBy = 'order_by', $ascdesc = 'asc', $limit_page = 0, $keyword = '')
    {
        $query = Products::query();

        if ($keyword != '') {
            $query = $query->searchKeyword($keyword);
        }

        $query = $query->orderBy($orderBy, $ascdesc);
        if ($limit_page == 0) {
            $result = $query->get();
        } else {
            $result = $query->paginate($limit_page);
        }

        if ($type == 1) {
            return response()->json(array('status' => 'success', 'data' => $result), 200);
        } else {
            return $result;
        }
    }

    public function getProductListFront(Request $request)
    {
        $query = Products::query();
        $query = $query->whereStatus("Active");
        $query = $query->orderBy("order_by", "ASC");
        $result = $query->get();
        return $result;
    }

    public function index(Request $request)
    {
        try {
            $query = Products::query();
            if ($request->input('where') !== null) {
                $where = $request->input('where');
                foreach ($where as $key => $value) {
                    $field = $key;
                    $cond = key($value);
                    $var = pos($value);
                    if ($cond == 7)
                        $var = "%" . $var . "%";
    
                    $query = $query->where($field, config("config.config_arr_condition")[$cond], $var);
                }
            }
    
            if ($request->input('order') !== null) {
                $order = $request->input('order');
                foreach ($order as $key => $value) {
                    $query = $query->orderBy($key, $value);
                }
            }
    
            if ($request->input('filter') !== null) {
                $filter = $request->input('filter');
    
                if ($filter["limit"] !== null && $filter["limit"] != 0) {
                    $query = $query->take($filter["limit"]);
                }
                if ($filter["offset"] !== null && $filter["offset"] != 0) {
                    $query = $query->offset(($filter["offset"] - 1));
                }
                if ($filter["skip"] !== null && $filter["skip"] != 0) {
                    $query = $query->skip($filter["skip"]);
                }
            }
    
            $data = $query->get();
    
            return response()->json([
                "success" => true,
                "total" => sizeof($data),
                'data' => $data,
                "msg" => "Get data success"
            ], 200);
        } catch (Exception $e) {
            return response()->json(array('success' => false, 'data' => $e, "message" => "Get all data fail"), 404);
        }
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title_th' => 'required',
            'title_en' => 'required',
            // 'url' => 'required|url',
        ],
        [
            'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
            'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
            // 'url.required' => 'กรุณาใส่ลิงค์',
            // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
        ]);

        if ($validator->fails()) {
            //return $validation->errors();
            return response()->json([
                "success" => false,
                'data' => null,
                "msg" => $validator->errors()
            ], 422);
        } else {
            $ip_address = $request->ip();
            if ($request->ip() == "::1") {
                $ip_address = "127.0.0.1";
            }

            $now = Carbon::now();
            $current_datetime = $now->toDateTimeString();

            $pathDate = $now->format("Y/m");
            $filenametostore = "";
            if ($request->hasFile('thumb')) {
                $pathFile = config('config.config_pathUpload') . '/products/' . $pathDate;
                File::isDirectory($pathDate) or File::makeDirectory($pathFile, 0777, true, true);
                $filenametostore = 'thumb-' . time() . '-' . str_replace(" ", "_", $request->thumb->getClientOriginalName());
                Helper::storageProcess("save", $pathFile, $filenametostore, $request->file('thumb'));
            }

            $filenametostore_thumb_album_1 = "";
            if ($request->hasFile('thumb_album_1')) {
                $pathFile = config('config.config_pathUpload') . '/products/' . $pathDate;
                File::isDirectory($pathDate) or File::makeDirectory($pathFile, 0777, true, true);
                $filenametostore_thumb_album_1 = 'thumb_album_1-' . time() . '-' . str_replace(" ", "_", $request->thumb_album_1->getClientOriginalName());
                Helper::storageProcess("save", $pathFile, $filenametostore_thumb_album_1, $request->file('thumb_album_1'));
            }

            $filenametostore_thumb_album_2 = "";
            if ($request->hasFile('thumb_album_2')) {
                $pathFile = config('config.config_pathUpload') . '/products/' . $pathDate;
                File::isDirectory($pathDate) or File::makeDirectory($pathFile, 0777, true, true);
                $filenametostore_thumb_album_2 = 'thumb_album_2-' . time() . '-' . str_replace(" ", "_", $request->thumb_album_2->getClientOriginalName());
                Helper::storageProcess("save", $pathFile, $filenametostore_thumb_album_2, $request->file('thumb_album_2'));
            }

            $filenametostore_thumb_album_3 = "";
            if ($request->hasFile('thumb_album_3')) {
                $pathFile = config('config.config_pathUpload') . '/products/' . $pathDate;
                File::isDirectory($pathDate) or File::makeDirectory($pathFile, 0777, true, true);
                $filenametostore_thumb_album_3 = 'thumb_album_3-' . time() . '-' . str_replace(" ", "_", $request->thumb_album_3->getClientOriginalName());
                Helper::storageProcess("save", $pathFile, $filenametostore_thumb_album_3, $request->file('thumb_album_3'));
            }

            $startDate = ($request->input("startDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("startDate"))->format("Y-m-d") : NULL;
            $endDate = ($request->input("endDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("endDate"))->format("Y-m-d") : NULL;

            $status = ($request->input("status") !== null) ? $request->input("status") : "Inactive";
            $order_by = 0;
            $created_by = ($request->input("created_by") !== null) ? $request->input("created_by") : 0;
            $updated_by = ($request->input("updated_by") !== null) ? $request->input("updated_by") : 0;

            $slug = Str::slug($request->input("title_en"));
            $countSlug = Products::whereSlug($slug)->count();
            if ($countSlug > 0)
                $slug = $slug.'-'.($countSlug+1);

            // dd($countSlug, $slug);
            $category_id = ($request->input("category_id") !== null) ? $request->input("category_id") : 1;
            $brand_id = ($request->input("brand_id") !== null) ? $request->input("brand_id") : 1;

            DB::beginTransaction();
            try {
                $product = new Products;
                $product->category_id = $category_id;
                $product->brand_id = $brand_id;
                $product->thumb = $filenametostore;
                $product->title_th = $request->input("title_th");
                $product->product_name_th = $request->input("product_name_th");
                $product->content_th = $request->input("content_th");
                $product->title_en = $request->input("title_en");
                $product->product_name_en = $request->input("product_name_en");
                $product->content_en = $request->input("content_en");
                $product->album_1 = $filenametostore_thumb_album_1;
                $product->album_2 = $filenametostore_thumb_album_2;
                $product->album_3 = $filenametostore_thumb_album_3;
                $product->slug = $slug;
                $product->startDate = $startDate;
                $product->endDate = $endDate;
                $product->visitor = $ip_address;
                $product->status = $status;
                $product->created_at = $current_datetime;
                $product->updated_at = $current_datetime;
                $product->created_by = $created_by;
                $product->updated_by = $updated_by;
                $product->order_by = $order_by;
                $product->save();

                $query = Products::query();
                $update_order = $query->increment("order_by");
                
                $data = array(
                    "product" => $product,
                );

                DB::commit();
                return response()->json(array('success' => true, 'data' => $data, "message" => "Successfully inserted"), 200);
            } catch (Exception $e) {
                DB::rollback();
                return response()->json(array('success' => false, 'data' => $e, "message" => "Inserted fail"), 404);
            }
        }
    }

    public function show($id)
    {
        $data = Products::find($id);
        if (empty($data)) {
            return response()->json([
                "success" => false,
                'data' => "",
                "msg" => ""
            ], 402);
        } else {
            return response()->json([
                "success" => true,
                "total" => $data->count(),
                'data' => $data,
                "msg" => "Get data by id success"
            ], 200);
        }
    }

    public function update(Request $request, $product_id = 0)
    {
        $validator = Validator::make($request->all(), [
            'title_th' => 'required',
            'title_en' => 'required',
            // 'url' => 'required|url',
        ],
        [
            'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
            'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
            // 'url.required' => 'กรุณาใส่ลิงค์',
            // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
        ]);

        if ($validator->fails()) {
            //return $validation->errors();
            return response()->json([
                "success" => false,
                'data' => null,
                "msg" => $validator->errors()
            ], 422);
        } else {

            $ip_address = $request->ip();
            if ($request->ip() == "::1") {
                $ip_address = "127.0.0.1";
            }

            $product = Products::find($product_id);
            if (empty($product)) {
                return response()->json(array('success' => false, 'data' => null, 'message' => 'No Data'), 200);
            }

            $now = Carbon::now();
            $current_datetime = $now->toDateTimeString();

            $pathDate = Carbon::parse($product->created_at)->format("Y/m");
            $pathFile = config('config.config_pathUpload') . '/products/' . $pathDate;

            $filenametostore = $product->thumb;
            if ($request->action_thumb=="delete")
            {
                $responDelete = Helper::storageProcess("delete", $pathFile, $filenametostore);
                $filenametostore = "";
            }
            if ($request->hasFile('thumb')) {
                File::isDirectory($pathDate) or File::makeDirectory($pathFile, 0777, true, true);
                $new_filenametostore = 'thumb-' . time() . '-' . str_replace(" ", "_", $request->thumb->getClientOriginalName());

                $responUpload = Helper::storageProcess("save", $pathFile, $new_filenametostore, $request->file('thumb'));
                if ($responUpload)
                {
                    $responDelete = Helper::storageProcess("delete", $pathFile, $filenametostore);
                    $filenametostore = $new_filenametostore;
                }
            }

            $filenametostore_album_1 = $product->album_1;
            if ($request->action_thumb_album_1=="delete")
            {
                $responDelete_album_1 = Helper::storageProcess("delete", $pathFile, $filenametostore_album_1);
                $filenametostore_album_1 = "";
            }
            if ($request->hasFile('thumb_album_1')) {
                File::isDirectory($pathDate) or File::makeDirectory($pathFile, 0777, true, true);
                $new_filenametostore_album_1 = 'thumb_album_1-' . time() . '-' . str_replace(" ", "_", $request->thumb_album_1->getClientOriginalName());

                $responUpload_album_1 = Helper::storageProcess("save", $pathFile, $new_filenametostore_album_1, $request->file('thumb_album_1'));
                if ($responUpload_album_1)
                {
                    $responDelete_album_1 = Helper::storageProcess("delete", $pathFile, $filenametostore_album_1);
                    $filenametostore_album_1 = $new_filenametostore_album_1;
                }
            }


            $filenametostore_album_2 = $product->album_2;
            if ($request->action_thumb_album_2=="delete")
            {
                $responDelete_album_2 = Helper::storageProcess("delete", $pathFile, $filenametostore_album_2);
                $filenametostore_album_2 = "";
            }
            if ($request->hasFile('thumb_album_2')) {
                File::isDirectory($pathDate) or File::makeDirectory($pathFile, 0777, true, true);
                $new_filenametostore_album_2 = 'thumb_album_2-' . time() . '-' . str_replace(" ", "_", $request->thumb_album_2->getClientOriginalName());

                $responUpload_album_2 = Helper::storageProcess("save", $pathFile, $new_filenametostore_album_2, $request->file('thumb_album_2'));
                if ($responUpload_album_2)
                {
                    $responDelete_album_2 = Helper::storageProcess("delete", $pathFile, $filenametostore_album_2);
                    $filenametostore_album_2 = $new_filenametostore_album_2;
                }
            }

            $filenametostore_album_3 = $product->album_3;
            if ($request->action_thumb_album_3=="delete")
            {
                $responDelete_album_3 = Helper::storageProcess("delete", $pathFile, $filenametostore_album_3);
                $filenametostore_album_3 = "";
            }
            if ($request->hasFile('thumb_album_3')) {
                File::isDirectory($pathDate) or File::makeDirectory($pathFile, 0777, true, true);
                $new_filenametostore_album_3 = 'thumb_album_3-' . time() . '-' . str_replace(" ", "_", $request->thumb_album_3->getClientOriginalName());

                $responUpload_album_3 = Helper::storageProcess("save", $pathFile, $new_filenametostore_album_3, $request->file('thumb_album_3'));
                if ($responUpload_album_3)
                {
                    $responDelete_album_3 = Helper::storageProcess("delete", $pathFile, $filenametostore_album_3);
                    $filenametostore_album_3 = $new_filenametostore_album_3;
                }
            }

            $startDate = ($request->input("startDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("startDate"))->format("Y-m-d") : $product->startDate;
            $endDate = ($request->input("endDate") !== null) ? Carbon::createFromFormat('d/m/Y', $request->input("endDate"))->format("Y-m-d") : $product->endDate;

            $status = ($request->input("status") !== null) ? $request->input("status") : $product->status;
            $order_by = ($request->input("order_by") !== null) ? $request->input("order_by") : $product->order_by;
            $created_by = ($request->input("created_by") !== null) ? $request->input("created_by") : 0;
            $updated_by = ($request->input("updated_by") !== null) ? $request->input("updated_by") : 0;

            $category_id = ($request->input("category_id") !== null) ? $request->input("category_id") : 1;
            $brand_id = ($request->input("brand_id") !== null) ? $request->input("brand_id") : 1;

            DB::beginTransaction();
            try {
                $product->category_id = $category_id;
                $product->brand_id = $brand_id;
                $product->thumb = $filenametostore;
                $product->title_th = $request->input("title_th");
                $product->product_name_th = $request->input("product_name_th");
                $product->content_th = $request->input("content_th");
                $product->title_en = $request->input("title_en");
                $product->product_name_en = $request->input("product_name_en");
                $product->content_en = $request->input("content_en");
                $product->album_1 = $filenametostore_album_1;
                $product->album_2 = $filenametostore_album_2;
                $product->album_3 = $filenametostore_album_3;
                $product->startDate = $startDate;
                $product->endDate = $endDate;
                $product->visitor = $ip_address;
                $product->status = $status;
                $product->updated_at = $current_datetime;
                $product->updated_by = $updated_by;
                $product->order_by = $order_by;

                $product->save();

                $data = array(
                    "product" => $product,
                );

                DB::commit();
                return response()->json(array('success' => true, 'data' => $data, "message" => "Successfully updated"), 200);
            } catch (Exception $e) {
                DB::rollback();
                return response()->json(array('success' => false, 'data' => $e, "message" => "Updated fail"), 404);
            }
        }
    }

    public function delete($id)
    {
        DB::beginTransaction();
        try {
            $product = Products::find($id);
            $product->delete();

            $products = Products::orderBy("order_by","asc")->get();
            if ($products && $products->count() > 0) {
                foreach ($products as $key => $value) {
                    $dataUpdate = array(
                        "order_by" => $key + 1,
                    );
                    $value->update($dataUpdate);
                }
            }

            $data = array(
                "id" => $id
            );

            DB::commit();
            return response()->json([
                "success" => true,
                'data' => $data,
                "msg" => "Product - delete data success"
            ], 200);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json([
                "success" => false,
                'data' => "",
                "msg" => "Product - error"
            ], 502);
        }
    }
}