<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Mail;
use Captcha;
use Validator;

class SystemsApiController extends Controller
{
    public function sendContact(Request $request)
    {
        $firstname = $request->firstname;
        $lastname = $request->lastname;
        $email = $request->email;
        $phone = $request->inputPhone;
        $msg = $request->message;
        $cc = $request->cc;

        try {
            Mail::send('emails.test', compact('firstname','lastname','email','phone',"cc","msg"), function($message) use ($firstname,$lastname, $email,$cc) {
                $message->from($email,$firstname." ".$lastname);
                if (isset($cc) && sizeof($cc)>0)
                {
                    foreach ($cc as $list)
                    {
                        $message->cc($list["email"],$list["fullname"]);
                    }
                }
                $message->to(config('config.config_arr_mailadmin.email'),config('config.config_arr_mailadmin.name'))->subject("มีข้อความเข้า");
            });

            return response()->json([
                "success"=>true,
                'data' => null,
                "msg" => "send email success"
            ], 200);
        } catch(\Exception $e) {
            return response()->json([
                "success"=>false,
                'data' => "",
                "msg" => "send email fail"
            ], 200);
        }
    }
}
