<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Model\OurBrands;
use Captcha;
//use Illuminate\Http\Response;
use Carbon\Carbon;
use Request;
use Session;
use Validator;
use App\Http\Controllers\Api\BannersApiController;
use App\Http\Controllers\Api\SystemsApiController;
use App\Model\Brooks;
use App\Model\Brands;

class BrandsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public $lang;

    //index
    public function index(Request $request)
    {
        $brand = $request->input("brand");
        $brand = Brands::find($brand);
        if (!empty($brand) && $brand->count() > 0) {
            $pathDate = Carbon::parse($brand->created_at)->format('Y/m');
            $brand->pathFile = config('config.config_pathUpload').'/brands/'.$pathDate;
        }

        $banners = new BannersApiController();
        $data_banners = $banners->getBannerListFront($request);
        if (!empty($data_banners) && $data_banners->count() > 0) {
            foreach ($data_banners as $banner) {
                $pathDate = Carbon::parse($banner->created_at)->format('Y/m');
                $banner->pathFile = config('config.config_pathUpload').'/banners/'.$pathDate;
            }
        }

        $data = array(
            'brand' => $brand,
            "banners" => $data_banners
        );

        return view('front.brand')->with($data);
    }

    //index
    public function brook(Request $request)
    {
        $this->lang = Session::get('locale');
        $banners = new BannersApiController();
        $data_banners = $banners->getBannerListFront($request);
        if (!empty($data_banners) && $data_banners->count() > 0) {
            foreach ($data_banners as $banner) {
                $pathDate = Carbon::parse($banner->created_at)->format('Y/m');
                $banner->pathFile = config('config.config_pathUpload').'/banners/'.$pathDate;
            }
        }

        $captcha = Captcha::src('default');

        $data = array(
            'banners' => $data_banners,
            'captcha' => $captcha,
        );

        return view('front.brook')->with($data);
    }

    public function mica(Request $request)
    {
        $this->lang = Session::get('locale');
        $banners = new BannersApiController();
        $data_banners = $banners->getBannerListFront($request);
        if (!empty($data_banners) && $data_banners->count() > 0) {
            foreach ($data_banners as $banner) {
                $pathDate = Carbon::parse($banner->created_at)->format('Y/m');
                $banner->pathFile = config('config.config_pathUpload').'/banners/'.$pathDate;
            }
        }

        $captcha = Captcha::src('default');

        $data = array(
            'banners' => $data_banners,
            'captcha' => $captcha,
        );

        return view('front.mica')->with($data);
    }

    public function obun(Request $request)
    {
        $this->lang = Session::get('locale');
        $banners = new BannersApiController();
        $data_banners = $banners->getBannerListFront($request);
        if (!empty($data_banners) && $data_banners->count() > 0) {
            foreach ($data_banners as $banner) {
                $pathDate = Carbon::parse($banner->created_at)->format('Y/m');
                $banner->pathFile = config('config.config_pathUpload').'/banners/'.$pathDate;
            }
        }

        $captcha = Captcha::src('default');

        $data = array(
            'banners' => $data_banners,
            'captcha' => $captcha,
        );

        return view('front.obun')->with($data);
    }

    public function nakao(Request $request)
    {
        $this->lang = Session::get('locale');
        $banners = new BannersApiController();
        $data_banners = $banners->getBannerListFront($request);
        if (!empty($data_banners) && $data_banners->count() > 0) {
            foreach ($data_banners as $banner) {
                $pathDate = Carbon::parse($banner->created_at)->format('Y/m');
                $banner->pathFile = config('config.config_pathUpload').'/banners/'.$pathDate;
            }
        }

        $captcha = Captcha::src('default');

        $data = array(
            'banners' => $data_banners,
            'captcha' => $captcha,
        );

        return view('front.nakao')->with($data);
    }

    public function hahne(Request $request)
    {
        $this->lang = Session::get('locale');
        $banners = new BannersApiController();
        $data_banners = $banners->getBannerListFront($request);
        if (!empty($data_banners) && $data_banners->count() > 0) {
            foreach ($data_banners as $banner) {
                $pathDate = Carbon::parse($banner->created_at)->format('Y/m');
                $banner->pathFile = config('config.config_pathUpload').'/banners/'.$pathDate;
            }
        }

        $captcha = Captcha::src('default');

        $data = array(
            'banners' => $data_banners,
            'captcha' => $captcha,
        );

        return view('front.hahne')->with($data);
    }

    public function cremello(Request $request)
    {
        $this->lang = Session::get('locale');
        $banners = new BannersApiController();
        $data_banners = $banners->getBannerListFront($request);
        if (!empty($data_banners) && $data_banners->count() > 0) {
            foreach ($data_banners as $banner) {
                $pathDate = Carbon::parse($banner->created_at)->format('Y/m');
                $banner->pathFile = config('config.config_pathUpload').'/banners/'.$pathDate;
            }
        }

        $captcha = Captcha::src('default');

        $data = array(
            'banners' => $data_banners,
            'captcha' => $captcha,
        );

        return view('front.cremello')->with($data);
    }

    public function glodenjim(Request $request)
    {
        $this->lang = Session::get('locale');
        $banners = new BannersApiController();
        $data_banners = $banners->getBannerListFront($request);
        if (!empty($data_banners) && $data_banners->count() > 0) {
            foreach ($data_banners as $banner) {
                $pathDate = Carbon::parse($banner->created_at)->format('Y/m');
                $banner->pathFile = config('config.config_pathUpload').'/banners/'.$pathDate;
            }
        }

        $captcha = Captcha::src('default');

        $data = array(
            'banners' => $data_banners,
            'captcha' => $captcha,
        );

        return view('front.goldenjim')->with($data);
    }

    public function sendContact(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'inputCaptcha' => 'required|captcha',
        ],
        [
            'inputCaptcha.required' => 'กรุณาใส่ Captcha',
            'inputCaptcha.captcha' => 'Captcha ไม่ถูกต้อง! กรุณาใส่ใหม่อีกครั้ง',
        ]);

        if ($validator->fails()) {
            $message = $validator->errors();

            return redirect()->back()->withErrors($message)->withInput();
        }

        $api = new SystemsApiController();
        $response = $api->sendContact($request);
        $result = json_decode($response->content(), false);
        $status = $result->success;
        dd($result);
        if ($status) {
            return redirect()->route('thankyou');
        }
        //return redirect()->route('home', ['rs' => "success"]);
    }

    public function thankyou(Request $request)
    {
        $this->lang = Session::get('locale');
        $banners = new BannersApiController();
        $data_banners = $banners->getBannerListFront($request);
        if (!empty($data_banners) && $data_banners->count() > 0) {
            foreach ($data_banners as $banner) {
                $pathDate = Carbon::parse($banner->created_at)->format('Y/m');
                $banner->pathFile = config('config.config_pathUpload').'/banners/'.$pathDate;
            }
        }

        $data = array(
            'banners' => $data_banners,
        );

        return view('front.thankyou')->with($data);
    }
}
