<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Captcha;
//use Illuminate\Http\Response;
use Carbon\Carbon;
use Request;
use Session;
use Validator;
use App\Http\Controllers\Api\BannersApiController;
use App\Http\Controllers\Api\SystemsApiController;
use App\Model\Brooks;

class BrookController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public $lang;

    //index
    public function index(Request $request)
    {
        $this->lang = Session::get('locale');

        $brooks = Brooks::front()->get();
        if (!empty($brooks) && $brooks->count() > 0) {
            foreach ($brooks as $brook) {
                $pathDate = Carbon::parse($brook->created_at)->format('Y/m');
                $brook->pathFile = config('config.config_pathUpload').'/brooks/'.$pathDate;
            }
        }

        $captcha = Captcha::src('default');

        $data = array(
            'brooks' => $brooks,
            'captcha' => $captcha,
        );

        return view('front.brook')->with($data);
    }
}
