<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Captcha;
//use Illuminate\Http\Response;
use Carbon\Carbon;
use Request;
use Session;
use Validator;
use App\Http\Controllers\Api\BannersApiController;
use App\Http\Controllers\Api\SystemsApiController;
use App\Model\Brooks;

class HahneController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public $lang;

    public function index(Request $request)
    {
        $this->lang = Session::get('locale');
        $banners = new BannersApiController();
        $data_banners = $banners->getBannerListFront($request);
        if (!empty($data_banners) && $data_banners->count() > 0) {
            foreach ($data_banners as $banner) {
                $pathDate = Carbon::parse($banner->created_at)->format('Y/m');
                $banner->pathFile = config('config.config_pathUpload').'/banners/'.$pathDate;
            }
        }

        $captcha = Captcha::src('default');

        $data = array(
            'banners' => $data_banners,
            'captcha' => $captcha,
        );

        return view('front.hahne')->with($data);
    }


}
