<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Captcha;
//use Illuminate\Http\Response;
use Carbon\Carbon;
use Request;
use Session;
use Validator;
use App\Http\Controllers\Api\BannersApiController;
use App\Http\Controllers\Api\SystemsApiController;
use App\Model\Brooks;
use App\Model\Micas;

class MicaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public $lang;

    public function index(Request $request)
    {
        $this->lang = Session::get('locale');
        $micas = Micas::front()->get();
        if (!empty($micas) && $micas->count() > 0) {
            foreach ($micas as $mica) {
                $pathDate = Carbon::parse($mica->created_at)->format('Y/m');
                $mica->pathFile = config('config.config_pathUpload').'/micas/'.$pathDate;
            }
        }

        $captcha = Captcha::src('default');

        $data = array(
            'micas' => $micas,
            'captcha' => $captcha,
        );

        return view('front.mica')->with($data);
    }
}
