<?php

namespace App\Http\Controllers\Webadmin;

use App\Http\Controllers\Controller;
use Auth;
use Carbon\Carbon;
use Request;
use Session;
use Storage;
use Validator;
use App\Http\Controllers\Api\BannersApiController;
use App\Model\Banners;
use App\Model\GlobalData;
use App\Model\OurBrands;
use App\PermissionRole;
use Symfony\Component\Console\Output\Output;

class BannersController extends Controller
{
    protected $limit_page = 30;

    public function __construct()
    {
        $this->middleware('auth');
        if (Session::has('limit_page.banners')) {
            if (Session::get('limit_page.banners') == "All") {
                $this->limit_page = Banners::count() + 1;
            } else {
                $this->limit_page = Session::get('limit_page.banners');
            }

        } else {
            Session::put('limit_page.banners', $this->limit_page);
        }

    }

    public function index(Request $request, $orderBy = "", $ascdesc = "", $search = "")
    {
        $query = Banners::query();
        if (Session::has('limit_page.banners')) {
            if (Session::get('limit_page.banners') == "All") {
                $this->limit_page = $query->count() + 1;
            } else {
                $this->limit_page = Session::get('limit_page.banners');
            }

        } else {
            Session::put('limit_page.banners', $this->limit_page);
        }

        $arr_data["orderBy"] = "order_by";
        $arr_data["ascdesc"] = "ASC";
        $arr_data["orderByUrl"] = "order_by";
        $arr_data["urlSearch"] = "";
        $arr_data["status_icon_sort"] = "";

        $search = (isset($search) && $search != "") ? trim($search) : "";
        $orderByUrl = (isset($orderBy) && $orderBy != "") ? $orderBy : "order_by";
        $orderBy = ($orderBy == "") ? "order_by" : $orderBy;
        $orderBy = ($orderBy == "order_by" || $orderBy == "") ? "order_by" : $orderBy;
        $orderBy = ($orderBy == "title") ? "title" : $orderBy;
        $orderBy = ($orderBy == "modify") ? "updated_at" : $orderBy;
        $ascdesc = (isset($ascdesc) && $ascdesc != "") ? $ascdesc : "ASC";

        //$arr_data["page"] = $page;
        $arr_data["search"] = $search;
        $arr_data["orderBy"] = $orderBy;
        $arr_data["ascdesc"] = $ascdesc;
        $arr_data["orderByUrl"] = $orderByUrl;
        $arr_data["urlSearch"] = "/" . $search;

        $arr_data["status_icon_sort"] = "";

        $banners = new BannersApiController;
        $data_banners = $banners->getBannerList($request, 2, $orderBy, $ascdesc, $this->limit_page, $search);
        if (!empty($data_banners)) {
            foreach ($data_banners as $banner) {
                $pathDate = Carbon::parse($banner->created_at)->format("Y/m");
                $banner->pathFile = config('config.config_pathUpload') . '/banners/' . $pathDate;
            }
        }

        $arr_data["start_sort"] = $data_banners->firstItem() - 1;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $getUsersData = GlobalData::getUsersData();

        $data = array(
            "hasPermission" => $hasPermission,
            "banners" => $data_banners,
            "arr_data" => $arr_data,
            'getUsersData' => $getUsersData,
        );

        if ($hasPermission["view-banners-list"]) {
            return view("web-admin.banners.index")->with($data);
        } else {
            return redirect(Route("cms.dashboard"));
        }

    }

    public function create(Request $request)
    {
        $banners = Banners::select('order_by')->latest('order_by')->first();
        $ourBrands = OurBrands::orderBy('order_by',"ASC")->get();
        $startDate = "";
        $endDate = "";


        $arr_data = array();
        if (empty($banners)) {
            $order = 0;
            $arr_data["order_by"] = 1;
        } else {
            $arr_data["order_by"] = $banners->order_by + 1;
        }

        $arr_data["disabled_data"] = false;

        $pathDate = date("Y") . "/" . date("m");

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $data = array(
            "hasPermission" => $hasPermission,
            'arr_data' => $arr_data,
            'pathDate' => $pathDate,
            'ourBrands' => $ourBrands
        );

        if ($hasPermission["create-banners"]) {
            return view("web-admin.banners.create")->with($data);
        } else {
            return redirect(Route("cms.banners.index"));
        }

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Respons
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "thumb" => 'mimes:jpg,jpeg,png|max:10000',
            "thumb_mobile" => 'mimes:jpg,jpeg,png|max:10000',
            'title' => 'required',
            // 'url' => 'required|url',
        ],
        [
            'thumb.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
            'thumb.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
            'thumb_mobile.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
            'thumb_mobile.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
            'title.required' => 'กรุณาใส่ชื่อ',
            // 'url.required' => 'กรุณาใส่ลิงค์',
            // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
        ]);

        if ($validator->fails()) {
            $message = $validator->errors();
            return redirect()->back()->withErrors($message)->withInput();
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        if ($hasPermission["create-banners"]) {
            $banner = new BannersApiController;
            $response = $banner->store($request);
            $result = json_decode($response->content(), false);
            $status = $result->success;
        } else {
            $result = "fail";
        }

        if ($status) {
            return redirect()->route('cms.banners.indexProcess', ['rs' => "success"]);
            //return redirect(url(config('config.config_pathCms') . '/dealer/banners/?rs=success'));
        } else {
            return redirect()->route('cms.banners.indexProcess', ['rs' => "error"]);
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $banner = Banners::find($id);
        if (empty($banner)) {
            abort(404);
        }

        $ourBrands = OurBrands::orderBy('order_by',"ASC")->get();
        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        $arr_data["disabled_data"] = true;
        $pathDate = Carbon::parse($banner->created_at)->format("Y/m");
        $banner->pathFile = config('config.config_pathUpload') . '/banners/' . $pathDate;

        $data = array(
            "hasPermission" => $hasPermission,
            "arr_data" => $arr_data,
            "banner" => $banner,
            "ourBrands" => $ourBrands
        );

        if ($hasPermission["view-banners-list"]) {
            return view('web-admin.banners.show')->with($data);
        } else {
            return redirect(url(config('config.config_pathCms')));
        }

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $banner = Banners::find($id);
        if (empty($banner)) {
            $order = 0;
            $arr_data["order_by"] = 1;
            abort(404);
        } else {
            $arr_data["order_by"] = $banner->order_by;
        }

        $ourBrands = OurBrands::orderBy('order_by',"ASC")->get();

        $arr_data["disabled_data"] = false;
        $pathDate = Carbon::parse($banner->created_at)->format("Y/m");
        $banner->pathFile = config('config.config_pathUpload') . '/banners/' . $pathDate;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $data = array(
            "hasPermission" => $hasPermission,
            "banner" => $banner,
            "arr_data" => $arr_data,
            "ourBrands" => $ourBrands
        );

        if ($hasPermission["edit-banners"]) {
            return view('web-admin.banners.edit')->with($data);
        } else {
            return redirect(Route("cms.banners.index"));
        }

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $banners = Banners::find($id);
        if (empty($banners)) {
            abort(404);
        }

        $response_success = false;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        $status = false;
        if ($hasPermission["edit-banners"]) {
            $validator = Validator::make($request->all(), [
                "thumb" => 'mimes:jpg,jpeg,png|max:10000',
                "thumb_mobile" => 'mimes:jpg,jpeg,png|max:10000',
                'title' => 'required',
                // 'url' => 'required|url',
            ],
            [
                'thumb.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
                'thumb.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
                'thumb_mobile.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
                'thumb_mobile.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
                'title.required' => 'กรุณาใส่ชื่อ',
                // 'url.required' => 'กรุณาใส่ลิงค์',
                // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
            ]);

            if ($validator->fails()) {
                $message = $validator->errors();
                return redirect()->back()->withErrors($message)->withInput();
            }

            $banner = new BannersApiController;
            $response = $banner->update($request, $id);
            $result = json_decode($response->content(), false);
            $status = $result->success;
        }

        if ($status) {
            return redirect()->route('cms.banners.indexProcess', ['rs' => "success"]);
            //return redirect(url(config('config.config_pathCms') . '/dealer/banners/?rs=success'));
        } else {
            return redirect()->route('cms.banners.indexProcess', ['rs' => "error"]);
        }
    }

    public function destroy($id)
    {
        $banner = Banners::find($id);
        if (empty($banner)) {
            echo "N";
            exit();
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        if ($hasPermission["edit-banners"]) {
            //$result_delete = $banners->delete();
            $banner = new BannersApiController;
            $response = $banner->delete($id);
            $result = json_decode($response->content(), false);
            $status = $result->success;
            if ($status) {
                echo "Y";
            } else {
                echo "N";
            }

        } else {
            echo "N";
        }
    }

    public function deleteAllSubContent(Request $request)
    {
        $refer_id = $request->refer_id;
        $isError = false;
        if (!empty($refer_id)) {
            foreach ($refer_id as $key => $id) {
                $banner = Banners::find($id);
                if (empty($banner)) {
                    echo "N";
                    exit();
                }

                $permission = new PermissionRole;
                $hasPermission = $permission->all_check_permission(Auth::user()->id);
                if ($hasPermission["edit-banners"]) {
                    //$result_delete = $banners->delete();
                    $banner = new BannersApiController;
                    $response = $banner->delete($id);
                    $result = json_decode($response->content(), false);
                    $status = $result->success;
                    if (!$status) {
                        $isError = true;
                        echo "N";
                        exit();
                    }
                } else {
                    echo "N";
                    exit();
                }
            }
        } else {
            echo "N";
            exit();
        }

        if (!$isError)
            echo "Y";
    }

}
