<?php

namespace App\Http\Controllers\Webadmin;

use App\Http\Controllers\Controller;
use Auth;
use Carbon\Carbon;
use Request;
use Session;
use Storage;
use Validator;
use App\Http\Controllers\Api\BrandsApiController;
use App\Model\Brands;
use App\Model\GlobalData;
use App\PermissionRole;


class BrandsController extends Controller
{
    protected $limit_page = 30;

    public function __construct()
    {
        $this->middleware('auth');
        if (Session::has('limit_page.brands')) {
            if (Session::get('limit_page.brands') == "All") {
                $this->limit_page = Brands::count() + 1;
            } else {
                $this->limit_page = Session::get('limit_page.brands');
            }

        } else {
            Session::put('limit_page.brands', $this->limit_page);
        }

    }

    public function index(Request $request, $orderBy = "", $ascdesc = "", $search = "")
    {
        $query = Brands::query();
        if (Session::has('limit_page.brands')) {
            if (Session::get('limit_page.brands') == "All") {
                $this->limit_page = $query->count() + 1;
            } else {
                $this->limit_page = Session::get('limit_page.brands');
            }

        } else {
            Session::put('limit_page.brands', $this->limit_page);
        }

        $arr_data["orderBy"] = "order_by";
        $arr_data["ascdesc"] = "ASC";
        $arr_data["orderByUrl"] = "order_by";
        $arr_data["urlSearch"] = "";
        $arr_data["status_icon_sort"] = "";

        $search = (isset($search) && $search != "") ? trim($search) : "";
        $orderByUrl = (isset($orderBy) && $orderBy != "") ? $orderBy : "order_by";
        $orderBy = ($orderBy == "") ? "order_by" : $orderBy;
        $orderBy = ($orderBy == "order_by" || $orderBy == "") ? "order_by" : $orderBy;
        $orderBy = ($orderBy == "title") ? "title_th" : $orderBy;
        $orderBy = ($orderBy == "modify") ? "updated_at" : $orderBy;
        $ascdesc = (isset($ascdesc) && $ascdesc != "") ? $ascdesc : "ASC";

        //$arr_data["page"] = $page;
        $arr_data["search"] = $search;
        $arr_data["orderBy"] = $orderBy;
        $arr_data["ascdesc"] = $ascdesc;
        $arr_data["orderByUrl"] = $orderByUrl;
        $arr_data["urlSearch"] = "/" . $search;

        $arr_data["status_icon_sort"] = "";

        $brands = new BrandsApiController;
        $data_brands = $brands->getBrandList($request, 2, $orderBy, $ascdesc, $this->limit_page, $search);

        $arr_data["start_sort"] = $data_brands->firstItem() - 1;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $getUsersData = GlobalData::getUsersData();

        $data = array(
            "hasPermission" => $hasPermission,
            "brands" => $data_brands,
            "arr_data" => $arr_data,
            'getUsersData' => $getUsersData,
        );

        if ($hasPermission["view-brands-list"]) {
            return view("web-admin.brands.index")->with($data);
        } else {
            return redirect(Route("cms.dashboard"));
        }

    }

    public function create(Request $request)
    {
        $brands = Brands::select('order_by')->latest('order_by')->first();
        $startDate = "";
        $endDate = "";

        $arr_data = array();
        if (empty($brands)) {
            $order = 0;
            $arr_data["order_by"] = 1;
        } else {
            $arr_data["order_by"] = $brands->order_by + 1;
        }

        $arr_data["disabled_data"] = false;

        $pathDate = date("Y") . "/" . date("m");

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $data = array(
            "hasPermission" => $hasPermission,
            'arr_data' => $arr_data,
            'pathDate' => $pathDate,
        );

        if ($hasPermission["create-brands"]) {
            return view("web-admin.brands.create")->with($data);
        } else {
            return redirect(Route("cms.brands.index"));
        }

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Respons
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title_th' => 'required',
            'title_en' => 'required',
            // 'url' => 'required|url',
        ],
        [
            'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
            'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
            // 'url.required' => 'กรุณาใส่ลิงค์',
            // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
        ]);

        if ($validator->fails()) {
            $message = $validator->errors();
            return redirect()->back()->withErrors($message)->withInput();
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        if ($hasPermission["create-brands"]) {
            $brand = new BrandsApiController;
            $response = $brand->store($request);
            $result = json_decode($response->content(), false);
            $status = $result->success;
        } else {
            $result = "fail";
        }

        if ($status) {
            return redirect()->route('cms.brands.indexProcess', ['rs' => "success"]);
            //return redirect(url(config('config.config_pathCms') . '/dealer/brands/?rs=success'));
        } else {
            return redirect()->route('cms.brands.indexProcess', ['rs' => "error"]);
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $brand = Brands::find($id);
        if (empty($brand)) {
            abort(404);
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        $arr_data["disabled_data"] = true;

        $data = array(
            "hasPermission" => $hasPermission,
            "arr_data" => $arr_data,
            "brand" => $brand,
        );

        if ($hasPermission["view-brands-list"]) {
            return view('web-admin.brands.show')->with($data);
        } else {
            return redirect(url(config('config.config_pathCms')));
        }

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $brand = Brands::find($id);
        if (empty($brand)) {
            $order = 0;
            $arr_data["order_by"] = 1;
            abort(404);
        } else {
            $arr_data["order_by"] = $brand->order_by;
        }

        $arr_data["disabled_data"] = false;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $data = array(
            "hasPermission" => $hasPermission,
            "brand" => $brand,
            "arr_data" => $arr_data,
        );

        if ($hasPermission["edit-brands"]) {
            return view('web-admin.brands.edit')->with($data);
        } else {
            return redirect(Route("cms.brands.index"));
        }

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $brands = Brands::find($id);
        if (empty($brands)) {
            abort(404);
        }

        $response_success = false;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        $status = false;
        if ($hasPermission["edit-brands"]) {
            $validator = Validator::make($request->all(), [
                'title_th' => 'required',
                'title_en' => 'required',
                // 'url' => 'required|url',
            ],
            [
                'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
                'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
                // 'url.required' => 'กรุณาใส่ลิงค์',
                // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
            ]);

            if ($validator->fails()) {
                $message = $validator->errors();
                return redirect()->back()->withErrors($message)->withInput();
            }

            $brand = new BrandsApiController;
            $response = $brand->update($request, $id);
            $result = json_decode($response->content(), false);
            $status = $result->success;
        }

        if ($status) {
            return redirect()->route('cms.brands.indexProcess', ['rs' => "success"]);
            //return redirect(url(config('config.config_pathCms') . '/dealer/brands/?rs=success'));
        } else {
            return redirect()->route('cms.brands.indexProcess', ['rs' => "error"]);
        }
    }

    public function destroy($id)
    {
        $brand = Brands::find($id);
        if (empty($brand)) {
            echo "N";
            exit();
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        if ($hasPermission["edit-brands"]) {
            //$result_delete = $brands->delete();
            $brand = new BrandsApiController;
            $response = $brand->delete($id);
            $result = json_decode($response->content(), false);
            $status = $result->success;
            if ($status) {
                echo "Y";
            } else {
                echo "N";
            }

        } else {
            echo "N";
        }
    }

    public function deleteAllSubContent(Request $request)
    {
        $refer_id = $request->refer_id;
        $isError = false;
        if (!empty($refer_id)) {
            foreach ($refer_id as $key => $id) {
                $brand = Brands::find($id);
                if (empty($brand)) {
                    echo "N";
                    exit();
                }

                $permission = new PermissionRole;
                $hasPermission = $permission->all_check_permission(Auth::user()->id);
                if ($hasPermission["edit-brands"]) {
                    //$result_delete = $brands->delete();
                    $brand = new BrandsApiController;
                    $response = $brand->delete($id);
                    $result = json_decode($response->content(), false);
                    $status = $result->success;
                    if (!$status) {
                        $isError = true;
                        echo "N";
                        exit();
                    }
                } else {
                    echo "N";
                    exit();
                }
            }
        } else {
            echo "N";
            exit();
        }

        if (!$isError)
            echo "Y";
    }

}
