<?php

namespace App\Http\Controllers\Webadmin;

use App\Http\Controllers\Controller;
use Auth;
use Carbon\Carbon;
use Request;
use Session;
use Storage;
use Validator;
use App\Http\Controllers\Api\ContentsApiController;
use App\Model\Contents;
use App\Model\GlobalData;
use App\PermissionRole;


class ContentsController extends Controller
{
    protected $limit_page = 30;

    public function __construct()
    {
        $this->middleware('auth');
        if (Session::has('limit_page.contents')) {
            if (Session::get('limit_page.contents') == "All") {
                $this->limit_page = Contents::count() + 1;
            } else {
                $this->limit_page = Session::get('limit_page.contents');
            }

        } else {
            Session::put('limit_page.contents', $this->limit_page);
        }

    }

    public function index(Request $request, $orderBy = "", $ascdesc = "", $search = "")
    {
        $query = Contents::query();
        if (Session::has('limit_page.contents')) {
            if (Session::get('limit_page.contents') == "All") {
                $this->limit_page = $query->count() + 1;
            } else {
                $this->limit_page = Session::get('limit_page.contents');
            }

        } else {
            Session::put('limit_page.contents', $this->limit_page);
        }

        $arr_data["orderBy"] = "order_by";
        $arr_data["ascdesc"] = "ASC";
        $arr_data["orderByUrl"] = "order_by";
        $arr_data["urlSearch"] = "";
        $arr_data["status_icon_sort"] = "";

        $search = (isset($search) && $search != "") ? trim($search) : "";
        $orderByUrl = (isset($orderBy) && $orderBy != "") ? $orderBy : "order_by";
        $orderBy = ($orderBy == "") ? "order_by" : $orderBy;
        $orderBy = ($orderBy == "order_by" || $orderBy == "") ? "order_by" : $orderBy;
        $orderBy = ($orderBy == "title") ? "title_th" : $orderBy;
        $orderBy = ($orderBy == "modify") ? "updated_at" : $orderBy;
        $ascdesc = (isset($ascdesc) && $ascdesc != "") ? $ascdesc : "ASC";

        //$arr_data["page"] = $page;
        $arr_data["search"] = $search;
        $arr_data["orderBy"] = $orderBy;
        $arr_data["ascdesc"] = $ascdesc;
        $arr_data["orderByUrl"] = $orderByUrl;
        $arr_data["urlSearch"] = "/" . $search;

        $arr_data["status_icon_sort"] = "";

        $contents = new ContentsApiController;
        $data_contents = $contents->getContentList($request, 2, $orderBy, $ascdesc, $this->limit_page, $search);
        if (!empty($data_contents)) {
            foreach ($data_contents as $content) {
                $pathDate = Carbon::parse($content->created_at)->format("Y/m");
                $content->pathFile = config('config.config_pathUpload') . '/contents/' . $pathDate;
            }
        }

        $arr_data["start_sort"] = $data_contents->firstItem() - 1;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $getUsersData = GlobalData::getUsersData();

        $data = array(
            "hasPermission" => $hasPermission,
            "contents" => $data_contents,
            "arr_data" => $arr_data,
            'getUsersData' => $getUsersData,
        );

        if ($hasPermission["view-contents-list"]) {
            return view("web-admin.contents.index")->with($data);
        } else {
            return redirect(Route("cms.dashboard"));
        }

    }

    public function create(Request $request)
    {
        $contents = Contents::select('order_by')->latest('order_by')->first();
        $startDate = "";
        $endDate = "";

        $arr_data = array();
        if (empty($contents)) {
            $order = 0;
            $arr_data["order_by"] = 1;
        } else {
            $arr_data["order_by"] = $contents->order_by + 1;
        }

        $arr_data["disabled_data"] = false;

        $pathDate = date("Y") . "/" . date("m");

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $data = array(
            "hasPermission" => $hasPermission,
            'arr_data' => $arr_data,
            'pathDate' => $pathDate,
        );

        if ($hasPermission["create-contents"]) {
            return view("web-admin.contents.create")->with($data);
        } else {
            return redirect(Route("cms.contents.index"));
        }

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Respons
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "thumb" => 'mimes:jpg,jpeg,png|max:10000',
            'title_th' => 'required',
            'title_en' => 'required',
            // 'url' => 'required|url',
        ],
        [
            'thumb.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
            'thumb.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
            'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
            'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
            // 'url.required' => 'กรุณาใส่ลิงค์',
            // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
        ]);

        if ($validator->fails()) {
            $message = $validator->errors();
            return redirect()->back()->withErrors($message)->withInput();
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        if ($hasPermission["create-contents"]) {
            $content = new ContentsApiController;
            $response = $content->store($request);
            $result = json_decode($response->content(), false);
            $status = $result->success;
        } else {
            $result = "fail";
        }

        if ($status) {
            return redirect()->route('cms.contents.indexProcess', ['rs' => "success"]);
            //return redirect(url(config('config.config_pathCms') . '/dealer/contents/?rs=success'));
        } else {
            return redirect()->route('cms.contents.indexProcess', ['rs' => "error"]);
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $content = Contents::find($id);
        if (empty($content)) {
            abort(404);
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        $arr_data["disabled_data"] = true;
        $pathDate = Carbon::parse($content->created_at)->format("Y/m");
        $content->pathFile = config('config.config_pathUpload') . '/contents/' . $pathDate;

        $data = array(
            "hasPermission" => $hasPermission,
            "arr_data" => $arr_data,
            "content" => $content,
        );

        if ($hasPermission["view-contents-list"]) {
            return view('web-admin.contents.show')->with($data);
        } else {
            return redirect(url(config('config.config_pathCms')));
        }

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $content = Contents::find($id);
        if (empty($content)) {
            $order = 0;
            $arr_data["order_by"] = 1;
            abort(404);
        } else {
            $arr_data["order_by"] = $content->order_by;
        }

        $arr_data["disabled_data"] = false;
        $pathDate = Carbon::parse($content->created_at)->format("Y/m");
        $content->pathFile = config('config.config_pathUpload') . '/contents/' . $pathDate;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $data = array(
            "hasPermission" => $hasPermission,
            "content" => $content,
            "arr_data" => $arr_data,
        );

        if ($hasPermission["edit-contents"]) {
            return view('web-admin.contents.edit')->with($data);
        } else {
            return redirect(Route("cms.contents.index"));
        }

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $contents = Contents::find($id);
        if (empty($contents)) {
            abort(404);
        }

        $response_success = false;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        $status = false;
        if ($hasPermission["edit-contents"]) {
            $validator = Validator::make($request->all(), [
                "thumb" => 'mimes:jpg,jpeg,png|max:10000',
                'title_th' => 'required',
                'title_en' => 'required',
                // 'url' => 'required|url',
            ],
            [
                'thumb.mimes' => 'image menu ต้องใช้ไฟล์ jpg,jpeg,png เท่านั้น',
                'thumb.max' => 'ขนาดไฟล์ต้องไม่เกิน 10mb',
                'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
                'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
                // 'url.required' => 'กรุณาใส่ลิงค์',
                // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
            ]);

            if ($validator->fails()) {
                $message = $validator->errors();
                return redirect()->back()->withErrors($message)->withInput();
            }

            $content = new ContentsApiController;
            $response = $content->update($request, $id);
            $result = json_decode($response->content(), false);
            $status = $result->success;
        }

        if ($status) {
            return redirect()->route('cms.contents.indexProcess', ['rs' => "success"]);
            //return redirect(url(config('config.config_pathCms') . '/dealer/contents/?rs=success'));
        } else {
            return redirect()->route('cms.contents.indexProcess', ['rs' => "error"]);
        }
    }

    public function destroy($id)
    {
        $content = Contents::find($id);
        if (empty($content)) {
            echo "N";
            exit();
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        if ($hasPermission["edit-contents"]) {
            //$result_delete = $contents->delete();
            $content = new ContentsApiController;
            $response = $content->delete($id);
            $result = json_decode($response->content(), false);
            $status = $result->success;
            if ($status) {
                echo "Y";
            } else {
                echo "N";
            }

        } else {
            echo "N";
        }
    }

    public function deleteAllSubContent(Request $request)
    {
        $refer_id = $request->refer_id;
        $isError = false;
        if (!empty($refer_id)) {
            foreach ($refer_id as $key => $id) {
                $content = Contents::find($id);
                if (empty($content)) {
                    echo "N";
                    exit();
                }

                $permission = new PermissionRole;
                $hasPermission = $permission->all_check_permission(Auth::user()->id);
                if ($hasPermission["edit-contents"]) {
                    //$result_delete = $contents->delete();
                    $content = new ContentsApiController;
                    $response = $content->delete($id);
                    $result = json_decode($response->content(), false);
                    $status = $result->success;
                    if (!$status) {
                        $isError = true;
                        echo "N";
                        exit();
                    }
                } else {
                    echo "N";
                    exit();
                }
            }
        } else {
            echo "N";
            exit();
        }

        if (!$isError)
            echo "Y";
    }

}
