<?php

namespace App\Http\Controllers\Webadmin;

use App\Http\Controllers\Controller;
use Auth;
use Carbon\Carbon;
use Request;
use Session;
use Storage;
use Validator;
use QrCode;
use File;
use App\Http\Controllers\Api\ProductsApiController;
use App\Model\Products;
use App\Model\Categories;
use App\Model\ProductBrands;
use App\Model\GlobalData;
use App\PermissionRole;

use SVG\SVG;
use SVG\Nodes\Shapes\SVGCircle;


class ProductsController extends Controller
{
    protected $limit_page = 30;

    public function __construct()
    {
        $this->middleware('auth');
        if (Session::has('limit_page.products')) {
            if (Session::get('limit_page.products') == "All") {
                $this->limit_page = Products::count() + 1;
            } else {
                $this->limit_page = Session::get('limit_page.products');
            }
        } else {
            Session::put('limit_page.products', $this->limit_page);
        }
    }

    public function index(Request $request, $orderBy = "", $ascdesc = "", $search = "")
    {
        $query = Products::query();
        if (Session::has('limit_page.products')) {
            if (Session::get('limit_page.products') == "All") {
                $this->limit_page = $query->count() + 1;
            } else {
                $this->limit_page = Session::get('limit_page.products');
            }
        } else {
            Session::put('limit_page.products', $this->limit_page);
        }

        $arr_data["orderBy"] = "order_by";
        $arr_data["ascdesc"] = "ASC";
        $arr_data["orderByUrl"] = "order_by";
        $arr_data["urlSearch"] = "";
        $arr_data["status_icon_sort"] = "";

        $search = (isset($search) && $search != "") ? trim($search) : "";
        $orderByUrl = (isset($orderBy) && $orderBy != "") ? $orderBy : "order_by";
        $orderBy = ($orderBy == "") ? "order_by" : $orderBy;
        $orderBy = ($orderBy == "order_by" || $orderBy == "") ? "order_by" : $orderBy;
        $orderBy = ($orderBy == "title") ? "title_th" : $orderBy;
        $orderBy = ($orderBy == "modify") ? "updated_at" : $orderBy;
        $ascdesc = (isset($ascdesc) && $ascdesc != "") ? $ascdesc : "ASC";

        //$arr_data["page"] = $page;
        $arr_data["search"] = $search;
        $arr_data["orderBy"] = $orderBy;
        $arr_data["ascdesc"] = $ascdesc;
        $arr_data["orderByUrl"] = $orderByUrl;
        $arr_data["urlSearch"] = "/" . $search;

        $arr_data["status_icon_sort"] = "";

        $products = new ProductsApiController;
        $data_products = $products->getProductList($request, 2, $orderBy, $ascdesc, $this->limit_page, $search);

        $now = Carbon::now();

        if (isset($data_products) && sizeof($data_products) > 0) {
            foreach ($data_products as $product) {
                $pathDate = Carbon::parse($product->created_at)->format("Y/m");
                $pathFile = config('config.config_pathUpload') . '/products/' . $pathDate;
                $product->pathFile = $pathFile;

                $catSlug = Categories::find($product->category_id);
                $brandSlug = ProductBrands::find($product->brand_id);

                // dd($catSlug, $brandSlug,  $product);

                if ($product->slug) {
                    $product->url = route('product', ['catSlug' => $catSlug->slug, 'brandSlug' => $brandSlug->slug, 'productSlug' => $product->slug]);
                }
            }
        }

        $arr_data["start_sort"] = $data_products->firstItem() - 1;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $getUsersData = GlobalData::getUsersData();

        $data = array(
            "hasPermission" => $hasPermission,
            "products" => $data_products,
            "arr_data" => $arr_data,
            'getUsersData' => $getUsersData,
        );

        if ($hasPermission["view-products-list"]) {
            return view("web-admin.products.index")->with($data);
        } else {
            return redirect(Route("cms.dashboard"));
        }
    }

    public function create(Request $request)
    {
        $products = Products::select('order_by')->latest('order_by')->first();
        $startDate = "";
        $endDate = "";

        $arr_data = array();
        if (empty($products)) {
            $order = 0;
            $arr_data["order_by"] = 1;
        } else {
            $arr_data["order_by"] = $products->order_by + 1;
        }

        $arr_data["disabled_data"] = false;

        $pathDate = date("Y") . "/" . date("m");

        $categories = Categories::get();
        $productBrands = ProductBrands::get();

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $data = array(
            "hasPermission" => $hasPermission,
            'arr_data' => $arr_data,
            'pathDate' => $pathDate,
            'categories' => $categories,
            'productBrands' => $productBrands
        );

        if ($hasPermission["create-products"]) {
            return view("web-admin.products.create")->with($data);
        } else {
            return redirect(Route("cms.products.product.index"));
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Respons
     */
    public function store(Request $request)
    {
        $validator = Validator::make(
            $request->all(),
            [
                'title_th' => 'required',
                'title_en' => 'required',
                // 'url' => 'required|url',
            ],
            [
                'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
                'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
                // 'url.required' => 'กรุณาใส่ลิงค์',
                // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
            ]
        );

        if ($validator->fails()) {
            $message = $validator->errors();
            return redirect()->back()->withErrors($message)->withInput();
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        if ($hasPermission["create-products"]) {
            $product = new ProductsApiController;
            $response = $product->store($request);
            $result = json_decode($response->content(), false);
            $status = $result->success;
        } else {
            $result = "fail";
        }

        if ($status) {
            return redirect()->route('cms.products.product.indexProcess', ['rs' => "success"]);
            //return redirect(url(config('config.config_pathCms') . '/dealer/products/?rs=success'));
        } else {
            return redirect()->route('cms.products.product.indexProcess', ['rs' => "error"]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $product = Products::find($id);
        if (empty($product)) {
            abort(404);
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        $now = Carbon::now();
        if ($product) {
            $pathDate = Carbon::parse($product->created_at)->format("Y/m");
            $pathFile = config('config.config_pathUpload') . '/products/' . $pathDate;
            $product->pathFile = $pathFile;
        }

        $arr_data["disabled_data"] = true;

        $catSlug = Categories::find($product->category_id);
        $brandSlug = ProductBrands::find($product->brand_id);

        $categories = Categories::get();
        $productBrands = ProductBrands::get();

        $url = '';
        if ($product->slug) {
            $url = route('product', ['catSlug' => $catSlug->slug, 'brandSlug' => $brandSlug->slug, 'productSlug' => $product->slug]);
        }

        $data = array(
            "hasPermission" => $hasPermission,
            "arr_data" => $arr_data,
            "product" => $product,
            'categories' => $categories,
            'productBrands' => $productBrands,
            'productCategory' => $catSlug,
            'url' => $url
        );

        // dd($data);

        if ($hasPermission["view-products-list"]) {
            return view('web-admin.products.show')->with($data);
        } else {
            return redirect(url(config('config.config_pathCms')));
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $product = Products::find($id);

        if (empty($product)) {
            $order = 0;
            $arr_data["order_by"] = 1;
            abort(404);
        } else {
            $arr_data["order_by"] = $product->order_by;
        }

        $catSlug = Categories::find($product->category_id);
        $brandSlug = ProductBrands::find($product->brand_id);

        $categories = Categories::get();
        $productBrands = ProductBrands::get();

        $url = '';
        if ($product->slug) {
            $url = route('product', ['catSlug' => $catSlug->slug, 'brandSlug' => $brandSlug->slug, 'productSlug' => $product->slug]);
        }

        if ($product) {
            $pathDate = Carbon::parse($product->created_at)->format("Y/m");
            $pathFile = config('config.config_pathUpload') . '/products/' . $pathDate;
            $product->pathFile = $pathFile;
        }

        $arr_data["disabled_data"] = false;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        $data = array(
            "hasPermission" => $hasPermission,
            "product" => $product,
            "arr_data" => $arr_data,
            'categories' => $categories,
            'productBrands' => $productBrands,
            'productCategory' => $catSlug,
            'url' => $url
        );

        // dd($data);

        if ($hasPermission["edit-products"]) {
            return view('web-admin.products.edit')->with($data);
        } else {
            return redirect(Route("cms.products.product.index"));
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $products = Products::find($id);
        if (empty($products)) {
            abort(404);
        }

        $response_success = false;

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);

        $status = false;
        if ($hasPermission["edit-products"]) {
            $validator = Validator::make(
                $request->all(),
                [
                    'title_th' => 'required',
                    'title_en' => 'required',
                    // 'url' => 'required|url',
                ],
                [
                    'title_th.required' => 'กรุณาใส่ชื่อภาษาไทย',
                    'title_en.required' => 'กรุณาใส่ชื่อภาษาอังกฤษ',
                    // 'url.required' => 'กรุณาใส่ลิงค์',
                    // 'url.url' => 'รูปแบบลิงค์ไม่ถูกต้อง! กรุณาใส่ลิงค์ใหม่',
                ]
            );

            if ($validator->fails()) {
                $message = $validator->errors();
                return redirect()->back()->withErrors($message)->withInput();
            }

            $product = new ProductsApiController;
            $response = $product->update($request, $id);
            $result = json_decode($response->content(), false);
            $status = $result->success;
        }

        if ($status) {
            return redirect()->route('cms.products.product.indexProcess', ['rs' => "success"]);
            //return redirect(url(config('config.config_pathCms') . '/dealer/products/?rs=success'));
        } else {
            return redirect()->route('cms.products.product.indexProcess', ['rs' => "error"]);
        }
    }

    public function destroy($id)
    {
        $product = Products::find($id);
        if (empty($product)) {
            echo "N";
            exit();
        }

        $permission = new PermissionRole;
        $hasPermission = $permission->all_check_permission(Auth::user()->id);
        if ($hasPermission["edit-products"]) {
            //$result_delete = $products->delete();
            $product = new ProductsApiController;
            $response = $product->delete($id);
            $result = json_decode($response->content(), false);
            $status = $result->success;
            if ($status) {
                echo "Y";
            } else {
                echo "N";
            }
        } else {
            echo "N";
        }
    }

    public function deleteAllSubContent(Request $request)
    {
        $refer_id = $request->refer_id;
        $isError = false;
        if (!empty($refer_id)) {
            foreach ($refer_id as $key => $id) {
                $product = Products::find($id);
                if (empty($product)) {
                    echo "N";
                    exit();
                }

                $permission = new PermissionRole;
                $hasPermission = $permission->all_check_permission(Auth::user()->id);
                if ($hasPermission["edit-products"]) {
                    //$result_delete = $products->delete();
                    $product = new ProductsApiController;
                    $response = $product->delete($id);
                    $result = json_decode($response->content(), false);
                    $status = $result->success;
                    if (!$status) {
                        $isError = true;
                        echo "N";
                        exit();
                    }
                } else {
                    echo "N";
                    exit();
                }
            }
        } else {
            echo "N";
            exit();
        }

        if (!$isError)
            echo "Y";
    }


    public function download(Request $request, $id)
    {
        $product = Products::find($id);
        $type = $request->type ? $request->type : 'svg';

        $now = Carbon::now();
        $current_datetime = $now->toDateTimeString();

        $pathDate = $now->format("Y/m");
        $filenametostore = "";
        $pathFile = config('config.config_pathUpload') . '/qrcode';
        File::deleteDirectory($pathFile);
        // $pathFile = $pathFile . '/' . $pathDate;
        File::isDirectory($pathDate) or File::makeDirectory($pathFile, 0777, true, true);
        $filenametostore = 'download-' . time() . '.' . $type;

        $catSlug = Categories::find($product->category_id);
        $brandSlug = ProductBrands::find($product->brand_id);

        // dd($catSlug, $brandSlug,  $product);

        $url = '';
        if ($product->slug) {
            $url = route('product', ['catSlug' => $catSlug->slug, 'brandSlug' => $brandSlug->slug, 'productSlug' => $product->slug]);
        }
        else {
            return null;
        }

        $file = $pathFile . '/' . $filenametostore;
        if ($type == 'svg') {
            $image = QrCode::format($type)->style('round')
                ->size(100)->errorCorrection('L')
                ->generate($url, $file);

            return Storage::download($file);
        } else if ($type == 'png') {
            if (!extension_loaded('imagick')){
                dd('imagick not installed');
            }

            $svg = QrCode::format($type)->style('round')
                ->size(100)->errorCorrection('L')
                ->generate($url, $file, 'image/png');

            return Storage::download($file);
        }
    }
}
