<?php



namespace App\Http\Requests\Webadmin;



use Illuminate\Foundation\Http\FormRequest;



class UserRequest extends FormRequest

{

    /**

     * Determine if the user is authorized to make this request.

     *

     * @return bool

     */

    public function authorize()

    {

        return true;

    }



    /**

     * Get the validation rules that apply to the request.

     *

     * @return array

     */

    public function rules()

    {

        return [

            'username' => 'required',

            'name' => 'required',

            'email' => 'required|email'

        ];

    }



    public function messages()

    {

        return [

            'username.required' => 'Please enter your username.',

            'name.required' => 'Please enter your name',

            'email.required' => 'Please enter your email',

            'email.email' => 'Invalid email format! Please re-enter email.'

        ];

    }

}

