<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Auth;

class Brands extends Model
{
    protected $table = 'brands';
    public $timestamps = true;

    protected $dates = [
        'startDate',
        'endDate',
        'created_at',
        'updated_at',
    ];

    protected $fillable = [
        'url',
        'title_th',
        'title_en',
        'visitor',
        'status',
        'created_at',
        'updated_at',
        'created_by',
        'updated_by',
        'order_by',
    ];

    //search keyword
    public static function scopeSearchKeyword($query, $search)
    {
    	$query = $query->where(function ($query2) use ($search) {
                        $query2->where('title_th', 'like', '%'.$search.'%')
                                ->orWhere('title_en', 'like', '%'.$search.'%');
	            	});
        return $query;
    }
    //end search keyword

}

