<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Auth;

class Products extends Model
{
    protected $table = 'products';
    public $timestamps = true;

    protected $dates = [
        'startDate',
        'endDate',
        'created_at',
        'updated_at',
    ];

    protected $fillable = [
        'category_id',
        'brand_id',
        'thumb',
        'title_th',
        'product_name_th',
        'content_th',
        'title_en',
        'product_name_en',
        'content_en',
        'slug',
        'visitor',
        'status',
        'created_at',
        'updated_at',
        'created_by',
        'updated_by',
        'order_by',
    ];

    //search keyword
    public static function scopeSearchKeyword($query, $search)
    {
    	$query = $query->where(function ($query2) use ($search) {
                        $query2->where('title_th', 'like', '%'.$search.'%')
                                ->orWhere('title_en', 'like', '%'.$search.'%');
	            	});
        return $query;
    }
    //end search keyword

}

