<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Carbon\Carbon;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('users'))
        {
            Schema::create('users', function (Blueprint $table) {
                $table->increments('id');
                $table->string('username')->nullable()->default(null);
                $table->string('name');
                $table->string('email')->unique();
                $table->string('password');
                $table->enum('status',['Y','N'])->nullable()->default("Y");
                $table->rememberToken();
                $table->timestamps();
            });
        }



        $current_time = \Carbon\Carbon::now()->toDateTimeString();
        DB::table('users')->insert([
            [
                'username' => "bird",
                'name' => "Bird",
                'email' => 'workjob999@gmail.com',
                'password' => bcrypt('Bird2013!'),
                'created_at' => $current_time,
                'updated_at' => $current_time,
            ],
            [
                'username' => "nod",
                'name' => "Nod",
                'email' => 'nodkrab@gmail.com',
                'password' => bcrypt('123456'),
                'created_at' => $current_time,
                'updated_at' => $current_time,
            ],
            [
                'username' => "admin",
                'name' => "Admin",
                'email' => 'admin@allinspire.co.th',
                'password' => bcrypt('12345'),
                'created_at' => $current_time,
                'updated_at' => $current_time,
            ]
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
