<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddUrlColumnData extends Migration
{
    public $set_table = array('banners','brands','ourBrands');

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        foreach ($this->set_table as $setTable)
        {
            if (!Schema::hasColumn($setTable, "url")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->string('url',255)->nullable()->default(null)->comment('url Ex.http://www.google.co.th')->after("id");
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
