<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContentsTable extends Migration
{
    public $set_table = array('brooks','micas','hahnes');
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        foreach ($this->set_table as $setTable)
        {
            if (!Schema::hasTable($setTable)) {
                Schema::create($setTable, function (Blueprint $table) {
                    $table->increments('id')->unsigned();
                    $table->string('thumb',255)->nullable()->default(null)->comment('ภาพปก Ex.สินค้า');
                    $table->string('title_th',255)->nullable()->default(null)->comment('ชื่อหมวด Ex.หมวดสินค้า');
                    $table->text('detail_th')->nullable()->default(null)->comment('รายละเอียดโดยย่อ Ex.รายละเอียด');
                    $table->integer('weight_th')->nullable()->default(0)->comment('น้ำหนัก Ex.weight');
                    $table->string('title_en',255)->nullable()->default(null)->comment('ชื่อหมวด Ex.หมวดสินค้า');
                    $table->text('detail_en')->nullable()->default(null)->comment('รายละเอียดโดยย่อ Ex.รายละเอียด');
                    $table->integer('weight_en')->nullable()->default(0)->comment('น้ำหนัก Ex.weight');
                    $table->string('slug')->nullable()->default(null)->comment('Slug Ex.home');
                    $table->string('slug_old')->nullable()->default(null)->comment('Slug old Ex.home');
                    $table->string('meta_keyword')->nullable()->default(null)->comment('meta keyword Ex.Amorn');
                    $table->string('meta_title')->nullable()->default(null)->comment('meta title Ex.Amorn');
                    $table->longText('meta_description')->nullable()->default(null)->comment('meta description Ex.Amorn');
                    $table->string('visitor', 45)->nullable()->default(null)->comment('Ip Address');
                    $table->enum('status', ['Active', 'Inactive'])->default('Active')->comment('Active = ใช้งาน,Inactive=ไม่ใช้งาน');
                    $table->timestamps();
                    $table->integer('created_by')->default('0')->comment('สร้างโดย');
                    $table->integer('updated_by')->default('0')->comment('แก้ไขโดย');
                    $table->integer('order_by')->default('0')->comment('ลำดับ');
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists($this->table);
    }
}
