<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnContentTable extends Migration
{
    public $set_table = array('brooks','micas','hahnes');

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        foreach ($this->set_table as $setTable)
        {
            if (!Schema::hasColumn($setTable, "endDate")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->date('endDate')->nullable()->default(null)->comment('startDate Ex.2020-05-24')->after("weight_en");
                });
            }

            if (!Schema::hasColumn($setTable, "startDate")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->date('startDate')->nullable()->default(null)->comment('startDate Ex.2020-05-23')->after("weight_en");
                });
            }

            if (!Schema::hasColumn($setTable, "url")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->string('url',255)->nullable()->default(null)->comment('url Ex.http://www.google.co.th')->after("weight_en");
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
