<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAlbumFieldColumnProductsTable extends Migration
{
    public $set_table = array('products');

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        foreach ($this->set_table as $setTable)
        {
            if (!Schema::hasColumn($setTable, "album_3")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->string('album_3',255)->nullable()->default(null)->comment('Album Ex.url')->after("url");
                });
            }

            if (!Schema::hasColumn($setTable, "album_2")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->string('album_2',255)->nullable()->default(null)->comment('Album Ex.url')->after("url");
                });
            }

            if (!Schema::hasColumn($setTable, "album_1")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->string('album_1',255)->nullable()->default(null)->comment('Album Ex.url')->after("url");
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        foreach ($this->set_table as $setTable)
        {
            if (Schema::hasColumn($setTable, "album_3")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->dropColumn("album_3");
                });
            }

            if (Schema::hasColumn($setTable, "album_2")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->dropColumn("album_2");
                });
            }

            if (Schema::hasColumn($setTable, "album_1")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->dropColumn("album_1");
                });
            }

            if (Schema::hasColumn($setTable, "content_th")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->dropColumn("content_th");
                });
            }

            if (Schema::hasColumn($setTable, "content_en")) {
                Schema::table($setTable, function (Blueprint $table) {
                    $table->dropColumn("content_en");
                });
            }
        }
    }
}
