@extends('layouts.front.main')

@section('page_title','Thankyou')
@section('active_menu_thankyou','active')

@section('page_style')
@stop

@section('content')
<!-- CONTENT -->
<section class="main-slider">
    @if (isset($banners) && $banners->count()>0)
    @foreach ($banners as $banner)
    <div class="item image">
        <span class="loading">Loading...</span>
        <figure>
            <div class="slide-image slide-media"
                style="background-image:url('{{Helper::storageProcess("get",$banner->pathFile,$banner->thumb)}}');">
                <a href="{{$banner->url ?? '#'}}"><img
                        data-lazy="{{Helper::storageProcess("get",$banner->pathFile,$banner->thumb)}}"
                        class="image-entity" /></a>
            </div>
        </figure>
    </div>
    @endforeach
    @endif
</section>
<section class="bg-gray py-5">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="text-center"><i class="far fa-check-circle fa-7x"></i></div>
                <h3 class="text__gray text-center">THANK YOU</h3>
                <h5 class="text-center">ขอบคุณที่ติดต่อเรา แล้วเราจะส่งข้อความกลับไป</h5>
            </div>
        </div>
    </div>
</section>
@stop

@section('page_script')
{!! Html::script('js/functionjs.js') !!}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
<script>
    var submitted = false;
    $(document).ready(function(){

        @if (isset($_GET["rs"]) && $_GET["rs"]=="success")
            Swal.fire({
                type: 'success',
                title: '<strong>Contact</strong>',
                html: '<span style="color:#FF0000">send Mail success</span>',
            });
        @endif

        $("#frmContact").on("submit",function()
        {
            var bool = true;
            var html = "";
            $("#frmContact input","#frmContact textarera").removeClass("is-invalid");
            $(".form-group small").hide();

            if ($("#inputFirstname").val() == "") {
                $("#inputFirstname").addClass("is-invalid");
                $(".classFirstname small").show();
                bool = false;
            }
            if ($("#inputLastname").val() == "") {
                $("#inputLastname").addClass("is-invalid");
                $(".classLastname small").show();
                bool = false;
            }

            if ($("#inputEmail").val() == "") {
                $("#inputEmail").addClass("is-invalid");
                $(".classEmail small").html("* กรุณาใส่อีเมล์");
                $(".classEmail small").show();
                bool = false;
            }
            else if  (!js_checkemail($("#inputEmail").val()))
            {
                $("#inputEmail").addClass("is-invalid");
                $(".classEmail small").html("* รูปแบบอีเมล์ไม่ถูกต้อง! กรูณาใส่อีเมล์ใหม่");
                $(".classEmail small").show();
                bool = false;
            }

            if ($("#inputPhone").val() == "") {
                $("#inputPhone").addClass("is-invalid");
                $(".classPhone small").html("* กรุณาใส่เบอร์โทร");
                $(".classPhone small").show();
                bool = false;
            }

            if ($("#inputMessage").val() == "") {
                $("#inputMessage").addClass("is-invalid");
                $(".classMessage small").show();
                bool = false;
            }

            if ($("#inputCaptcha").val() == "") {
                $("#inputCaptcha").addClass("is-invalid");
                $(".classCaptcha small").show();
                bool = false;
            }

            if (bool)
            {
                if (!submitted)
                {
                    $("#frmContact").submit();
                }
            }
            else
            {
                Swal.fire({
                    type: 'error',
                    title: '<strong>Register</strong>',
                    html: '<span style="color:#FF0000">กรุณากรอกข้อมูลให้ครบถ้วน</span>',
                })
            }
            return false;
        })
    })
</script>
@stop