@if ($paginator->hasPages())
<nav aria-label="pagenavigation" class="{!! @$class_add !!}">
    <ul class="pagination justify-content-center align-items-center pt-3">
        {{-- Previous Page Link --}}
        @if ($paginator->total()>1 && $paginator->currentPage()>1)
            <li class="page-item">
                <a class="page-link" href="{{ $paginator->previousPageUrl() }}" rel="prev">
                    <img src="{{ url('img/icons/icon-right-double-open.svg') }}" alt="" class="icon flip">
                </a>
            </li>
        @endif

        {{-- Pagination Elements --}}
        @foreach ($elements as $element)
            {{-- "Three Dots" Separator --}}
            @if (is_string($element))
                <li class="page-item disabled"><a class="page-link" href="#">{{ $element }}</a></li>
            @endif

            {{-- Array Of Links --}}
            @if (is_array($element))
                @foreach ($element as $page => $url)
                {{-- {{ $limit."==".$page."==".$paginator->currentPage() }} --}}
                    @if ($page!=1 && $page!=$paginator->lastPage() && abs($paginator->currentPage()-$page)==$limit+1)
                        <li class="page-item">
                            <a class="page-link" href="#"><span>...</span></a>
                        </li>
                    @elseif ($page==1 || $page==$paginator->lastPage() || abs($paginator->currentPage()-$page)<=$limit)
                        @if ($page == $paginator->currentPage())
                            <li class="page-item active"><a class="page-link" href="#"><span>{{ $page }}</span></a></li>
                        @else
                            <li class="page-item"><a class="page-link" href="{{ $url }}"><span>{{ $page }}</span></a></li>
                        @endif
                    @endif
                @endforeach
            @endif
        @endforeach

        {{-- Next Page Link --}}
        @if ($paginator->hasMorePages())
            <li class="page-item">
                <a class="page-link" href="{{ $paginator->nextPageUrl() }}" rel="next">
                    <img src="{{ url('img/icons/icon-right-double-open.svg') }}" alt="" class="icon">
                </a>
            </li>
        @else
            {{-- <li class="page-item disabled"><span>&raquo;</span></li> --}}
        @endif
    </ul>
</nav>
@endif
