@extends('layouts.web-admin.main')

@section('page_title', 'OurBrands')
@section('page_action', 'List Data')
@section('menu_active_ourBrands',' active ')

@section('page_nav')
<li><a href="{{Route('cms.ourBrands.index')}}">OurBrands</a></li>
<li class="active">List Data</li>
@stop

@section('page_style')
@stop


@section('content')
<!-- Content Header (Page header) -->

<section class="section-container section-with-top-border p-b-5">

  @include('layouts.web-admin.massage_block')

  <div class="row">
    <div class="col-md-12">


      <div class="panel">
        <div class="panel-heading">

          <div class="panel-heading-btn">
            <div class="pull-right">
              <button class="btn btn-default-sm" type="button" onclick="js_searchData('ourBrands')">
                <i class="fa fa-search"></i>
              </button>
            </div>
            <div class="pull-right">
              @if (isset($arr_data["search"]))
              <input type="text" class="form-control" name="search" id="search" value="{{ $arr_data['search'] }}"
                placeholder="Search...">
              @else
              <input type="text" class="form-control" name="search" id="search" placeholder="Search...">
              @endif
            </div>
          </div>

          <h4 class="panel-title">
            Total number of OurBrands : {{ $ourBrands->total() }}
            @if ($hasPermission["create-ourBrands"])
            &nbsp;&nbsp;
            <a href="javascript:void(0)" onclick="location='{{Route('cms.ourBrands.create')}}'"
              class="btn btn-xs btn-icon btn-circle btn-grey" data-click="panel-collapse" title="Add Data"><i
                class="fa fa-plus"></i></a>
            @endif
            @if ($hasPermission["edit-ourBrands"])
            &nbsp;&nbsp;
            <a href="javascript:void(0)" onclick="js_deleteAllSubContent('ourBrands')"
              class="btn btn-xs btn-icon btn-circle btn-danger" data-click="panel-collapse" title="Delete Data"><i
                class="fas fa-minus"></i></a>

            @endif
          </h4>
        </div>

        <!-- /.box-header -->
        <div id="data-table_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">

          <table id="tbl_dataList" rel="ourBrands"
            class="table table-bordered table-hover dataTable no-footer dtr-inline table-responsive">
            <thead>
              <tr>
                <th style="width: 4%">
                  @if ($arr_data["orderByUrl"] == "order_by")
                  {{-- {{$arr_data["orderByUrl"]."==".$arr_data["ascdesc"]}} --}}
                  @if ($arr_data["ascdesc"] == "ASC")
                  <a href="javascript:void(0)"><i class="fas fa-sort-alpha-down pull-right"></i></a>
                  @endif
                  @else
                  <a
                    href="{{ url(config('config.config_pathCms').'/ourBrands') }}/order_by/ASC{{ $arr_data['urlSearch'] }}?page={{ $ourBrands->currentPage() }}"><i
                      class="fas fa-sort-alpha-up pull-right text-muted"></i></a>
                  @endif
                </th>
                <th class="text-center" style="width: 4%">
                  <p class=""><input type="checkbox" id="chk_all" onclick="js_chkAll()" class="chk_all" value="Y"></p>
                </th>
                <th style="width: 5%">
                  <p class="pull-left">รูป</p>
                </th>
                <th style="width:46%">
                  <p class="pull-left">ชื่อ</p>
                  <p class="pull-right">
                    @if ($arr_data["orderByUrl"] == "title")
                    @if ($arr_data["ascdesc"] == "asc")
                    <a href="{{ url(config('config.config_pathCms').'/ourBrands') }}/title/DESC{{ $arr_data['urlSearch'] }}?page={{ $ourBrands->currentPage() }}"
                      class="pull-right"><i class="fas fa-sort-alpha-down"></i></a>
                    @else
                    <a href="{{ url(config('config.config_pathCms').'/ourBrands') }}/title/ASC{{ $arr_data['urlSearch'] }}?page={{ $ourBrands->currentPage() }}"
                      class="pull-right"><i class="fas fa-sort-alpha-up"></i></a>
                    @endif
                    @else
                    <a href="{{ url(config('config.config_pathCms').'/ourBrands') }}/title/DESC{{ $arr_data['urlSearch'] }}?page={{ $ourBrands->currentPage() }}"
                      class="pull-right"><i class="fas fa-sort-alpha-down text-muted"></i></a>
                    @endif
                  </p>
                </th>
                <th style="width: 6%">
                  <p class="pull-left">Status</p>
                </th>
                <th style="width: 20%">
                  <p class="pull-left">Modified date</p>
                  <p class="pull-right">
                    @if ($arr_data["orderByUrl"] == "modify")
                    @if ($arr_data["ascdesc"] == "asc")
                    <a href="{{ url(config('config.config_pathCms').'/ourBrands') }}/modify/DESC{{ $arr_data['urlSearch'] }}?page={{ $ourBrands->currentPage() }}"
                      class="pull-right"><i class="fas fa-sort-alpha-down"></i></a>
                    @else
                    <a href="{{ url(config('config.config_pathCms').'/ourBrands') }}/modify/ASC{{ $arr_data['urlSearch'] }}?page={{ $ourBrands->currentPage() }}"
                      class="pull-right"><i class="fas fa-sort-alpha-up"></i></a>
                    @endif
                    @else
                    <a href="{{ url(config('config.config_pathCms').'/ourBrands') }}/modify/DESC{{ $arr_data['urlSearch'] }}?page={{ $ourBrands->currentPage() }}"
                      class="pull-right"><i class="fas fa-sort-alpha-down text-muted"></i></a>
                    @endif
                  </p>
                </th>
                <th class="text-center" style="width: 15%">
                  <p class="">Process</p>
                </th>
              </tr>
            </thead>
            <tbody>
              @if (isset($ourBrands) && $ourBrands->count()>0)
              @foreach($ourBrands as $ourBrand)
              <tr class="tr_sorted" rel="tr_{{ $ourBrand->id }}">
                <td class="text-center"><i class="fa fa-bars {{ $arr_data['status_icon_sort'] }} class_icon_sort"
                    aria-hidden="true"></i></td>
                <td class="text-center">
                  <input type="checkbox" id="chk_{{ $ourBrand->id }}" name="chk_{{ $ourBrand->id }}" class="class_chk"
                    value="{{ $ourBrand->id }}" />
                </td>
                <td>
                  <img
                    src="{{ !empty($ourBrand) && Helper::storageProcess("get",$ourBrand->pathFile,$ourBrand->thumb)!=""?Helper::storageProcess("get",$ourBrand->pathFile,$ourBrand->thumb): asset('assets/noimage.jpg') }}"
                    id="img_responsive" style="width: 100px;">
                </td>
                <td>
                  {{ $ourBrand->title_th." / ".$ourBrand->title_en }}<br /><br />
                  <small>Start Date :
                    {{ !empty($ourBrand->startDate)?\Carbon\Carbon::parse($ourBrand->startDate)->format('d/m/Y'):''}}</small><br />
                  <small>Endn Date :
                    {{ !empty($ourBrand->endDate)?\Carbon\Carbon::parse($ourBrand->endDate)->format('d/m/Y'):''}}</small><br />
                </td>
                <td>
                  @if (!$hasPermission["edit-ourBrands"])
                  <a id="btn_statusDataActive-{{$ourBrand->id}}" href="javascript:void(0)"
                    class="btn btn-success btn-xs btn-rounded p-l-10 p-r-10">
                    {{ config('config.config_arr_status')["Y"] }}</a>
                  @else
                  @if ($ourBrand->status==="Active")
                  <a id="btn_statusDataActive-{{$ourBrand->id}}" href="javascript:void(0)"
                    onclick="js_changeStatus('ourBrands',{{ $ourBrand->id }},'Active')"
                    class="btn btn-success btn-xs btn-rounded p-l-10 p-r-10">
                    {{ config('config.config_arr_status')["Y"] }}</a>

                  <a id="btn_statusDataInactive-{{$ourBrand->id}}" href="javascript:void(0)"
                    onclick="js_changeStatus('ourBrands',{{ $ourBrand->id }},'Inactive')"
                    class="btn btn-danger btn-xs btn-rounded p-l-10 p-r-10 hide">
                    {{ config('config.config_arr_status')["N"] }}</a>

                  @else
                  <a id="btn_statusDataActive-{{$ourBrand->id}}" href="javascript:void(0)"
                    onclick="js_changeStatus('ourBrands',{{ $ourBrand->id }},'Active')"
                    class="btn btn-success btn-xs btn-rounded p-l-10 p-r-10 hide">
                    {{ config('config.config_arr_status')["Y"] }}</a>

                  <a id="btn_statusDataInactive-{{$ourBrand->id}}" href="javascript:void(0)"
                    onclick="js_changeStatus('ourBrands',{{ $ourBrand->id }},'Inactive')"
                    class="btn btn-danger btn-xs btn-rounded p-l-10 p-r-10 ">
                    {{ config('config.config_arr_status')["N"] }}</a>
                  @endif
                  @endif
                </td>
                <td>
                  {{-- {{ \Carbon\Carbon::parse($ourBrand->created_at)->diffForHumans() }}<br> --}}
                  {{ \Carbon\Carbon::parse($ourBrand->created_at)->format("d/m/Y H:i:s") }}<br>
                  @if (!empty($ourBrand->updated_by))
                  Edit By : {{\User::find($ourBrand->updated_by)->first()->name}}
                  @endif
                </td>
                <td>
                  <a href="{{ Route('cms.ourBrands.show',['id'=>$ourBrand->id]) }}"
                    class="btn btn-default btn-xs btn-block btn-rounded p-l-10 p-r-10"><i
                      class="fa fa-fw fa-play"></i>View</a>
                  @if ($hasPermission["edit-ourBrands"])
                  <a href="{{ Route('cms.ourBrands.edit',['id'=>$ourBrand->id]) }}"
                    class="btn btn-default btn-xs btn-block btn-rounded p-l-10 p-r-10"><i
                      class="fa fa-fw fa-edit"></i>Edit</a>

                  <a href="javascript:void(0)" onclick="js_deleteContent('ourBrands','{{ $ourBrand->id }}')"
                    class="btn btn-danger btn-xs btn-block btn-rounded p-l-10 p-r-10"><i
                      class="fa fa-fw fa-trash"></i>Delete</a>
                  @endif
                </td>
              </tr>
              @endforeach
              @else
              <tr>
                <td colspan="7" class="text-danger text-center">--No Data--</td>
              </tr>
              @endif
            </tbody>
          </table>

          <div class="row" style="margin-bottom: 10px;">
            <div class="col-md-5 col-sm-7">
              <div class="row">
                <div class="col-lg-2 col-md-4 col-sm-4 text-right">
                  {!! Form::select('option_limit_page', config('config.config_arr_limit_page'),
                  Session::get('limit_page.ourBrands'),
                  ["class"=>"form-control","id"=>"option_limit_page","onchange"=>"js_changeLimitPage('ourBrands',this.value)"]);
                  !!}
                </div>
                <div class="col-lg-10 col-md-8 col-sm-8">
                  Showing {{ $ourBrands->firstItem() }} to {{ $ourBrands->lastItem() }} of {{ $ourBrands->total() }} entries
                </div>
              </div>
            </div>
            <!-- /.col-sm-5 -->
            <div class="col-sm-7 text-right">
              {{ $ourBrands->render() }}
            </div>
            <!-- /.col-sm-7 -->

          </div>
          <!-- /.row -->

        </div>
        <!-- /.box-header -->

      </div>
      <!-- /.box -->


    </div>
    <!-- /.col -->
  </div>
  <!-- /.row -->
</section>
<!-- /.content -->

@stop


@section('page_script')
{!! Html::script('js/functionjs.js') !!}
@stop