@extends('layouts.web-admin.main')

@section('page_title', 'ProductBrands')
@section('page_action', 'Edit Data')
@section('menu_active_products',' active ')
@section('submenu_active_productBrands',' active ')

@section('page_style')
    {!! Html::script('js/ckeditor/ckeditor.js') !!}
    {!! Html::script('js/cke_config.js') !!}
@stop

@section('page_nav')
  <li><a href="{{Route('cms.products.brand.index')}}">ProductBrands</a></li>
  <li class="active">Edit Data</li>
@stop

@section('content')
<!-- Main content -->
<section class="section-container section-with-top-border p-b-5">

  <div class="row">
    <div class="col-md-12">

        @if($errors->any())
          <ul class="alert alert-danger">
            @foreach($errors->all() as $error)
              <li>{{ $error }}</li>
            @endforeach
          </ul>
        @endif

        <div class="panel p-20">
            <!-- /.box-header -->
            <!-- form start -->

              {!! Form::model($productBrand, ['method' => 'patch','class'=>"form-horizontal",'files' => true,'action'=>['Webadmin\ProductBrandsController@update', $productBrand->id]]) !!}
                  @include('web-admin.productBrands._form',['submitButtonText' => 'Save'])
              {!! Form::close() !!}


          </div>


    </div>
    <!-- /.col -->
  </div>
  <!-- /.row -->
</section>
<!-- /.content -->
@stop


@section('page_script')
    <script type="text/javascript">
        $(function(){
            $(window).on("load resize",(function() {
                    /* Act on the event */
                    setTimeout(function(){
                        $('.class_ckeditor').each(function(index, el) {
                            CKEDITOR.replace($('.class_ckeditor:eq('+index+')').attr('id'),cke_config);
                        });
                    },200);
                })
            );
        });

    </script>
@stop
