<style>
  .inline-content {
    padding: 10px;
    border: 0px solid #FF0000;
  }

  .inline-content:focus-visible {
    outline: none;
  }

  .microsite {
    /* background: url('{{ url("dist") }}/images/microsite/bg-microsite.jpg'); */
    color: #402F30;
  }

  .microsite .container {
    background-color: #fff;
  }

  .microsite .banner {
    height: 230px;
  }

  .microsite .banner img {
    height: 230px;
    object-fit: cover;
  }

  @media screen and (min-width: 768px) {
    .microsite .banner {
      height: auto;
    }
  }

  .microsite .language {
    padding: 10px 0;
    color: #403134;
    list-style: none;
    display: flex;
  }

  .microsite .language li {
    font-size: smaller;
  }

  .microsite .language li a {
    display: flex;
    flex-direction: column;
    color: #402F30;
    justify-content: center;
    align-items: center;
    padding: 0px 10px;
    font-size: smaller;
    opacity: 0.5;
  }

  .microsite .language li a:hover,
  .microsite .language li a.active {
    opacity: 1;
  }

  .microsite .text-title,
  .microsite .product-name {
    font-size: xx-large;
    color: #413031;
    font-weight: bolder;
  }

  .microsite .text-title {
    font-family: 'Kosugi';
    font-weight: bolder;
  }

  .microsite .product-name {
    font-family: 'Dosis';
    font-weight: 800;
  }

  .microsite .icon {
    display: flex;
    align-items: center;
    padding-left: 40px;
    margin: 15px 0;
  }


  /* red */

  .microsite.red .line {
    height: 25px;
    background-color: #d2161a;
    display: block;
  }

  .microsite.red .icon.features {
    background: url('{{ url("dist") }}/images/microsite/icon-features-red.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.red .icon.ingredient {
    background: url('{{ url("dist") }}/images/microsite/icon-ingredient-red.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.red .icon.direction {
    background: url('{{ url("dist") }}/images/microsite/icon-direction-red.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.red .icon.alert {
    background: url('{{ url("dist") }}/images/microsite/icon-alert-red.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.red .icon.storage {
    background: url('{{ url("dist") }}/images/microsite/icon-storage-red.svg') no-repeat left center;
    background-size: 30px 38px;
  }

  .microsite.red .icon.warnings {
    background: url('{{ url("dist") }}/images/microsite/icon-warnings-red.svg') no-repeat left center;
    background-size: 30px 28px;
  }

  .microsite.red .icon.weight {
    background: url('{{ url("dist") }}/images/microsite/icon-weight-red.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.red .icon.tipandtrick {
    background: url('{{ url("dist") }}/images/microsite/icon-tiptrick-red.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.red .icon span {
    padding-top: 5px;
    color: #d2161a;
    font-size: 22px;
    font-weight: 800;
  }

  .microsite.red hr {
    border-top: 1px solid #d2161a;
  }

  .microsite.red .recipe {
    display: inline-block;
    border-radius: 20px;
    background-color: #d2161a;
    padding: 8px 20px;
    margin: 20px 0;
  }

  .microsite .recipe span {
    padding-top: 5px;
    padding-left: 5px;
    font-weight: 600;
    color: #fff;
  }

  /* orange */

  .microsite.orange .line {
    height: 25px;
    background-color: #E79918;
    display: block;
  }

  .microsite.orange .icon.features {
    background: url('{{ url("dist") }}/images/microsite/icon-features-orange.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.orange .icon.ingredient {
    background: url('{{ url("dist") }}/images/microsite/icon-ingredient-orange.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.orange .icon.direction {
    background: url('{{ url("dist") }}/images/microsite/icon-direction-orange.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.orange .icon.alert {
    background: url('{{ url("dist") }}/images/microsite/icon-alert-orange.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.orange .icon.storage {
    background: url('{{ url("dist") }}/images/microsite/icon-storage-orange.svg') no-repeat left center;
    background-size: 30px 38px;
  }

  .microsite.orange .icon.warnings {
    background: url('{{ url("dist") }}/images/microsite/icon-warnings-orange.svg') no-repeat left center;
    background-size: 30px 28px;
  }

  .microsite.orange .icon.weight {
    background: url('{{ url("dist") }}/images/microsite/icon-weight-orange.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.orange .icon.tipandtrick {
    background: url('{{ url("dist") }}/images/microsite/icon-tiptrick-orange.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.orange .icon span {
    padding-top: 5px;
    color: #E79918;
    font-size: 22px;
    font-weight: 800;
  }

  .microsite.orange hr {
    border-top: 1px solid #E79918;
  }

  .microsite.orange .recipe {
    display: inline-block;
    border-radius: 20px;
    background-color: #E79918;
    padding: 8px 20px;
    margin: 20px 0;
  }


  /* yellow */

  .microsite.yellow .line {
    height: 25px;
    background-color: #E4B30D;
    display: block;
  }

  .microsite.yellow .icon.features {
    background: url('{{ url("dist") }}/images/microsite/icon-features-yellow.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.yellow .icon.ingredient {
    background: url('{{ url("dist") }}/images/microsite/icon-ingredient-yellow.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.yellow .icon.direction {
    background: url('{{ url("dist") }}/images/microsite/icon-direction-yellow.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.yellow .icon.alert {
    background: url('{{ url("dist") }}/images/microsite/icon-alert-yellow.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.yellow .icon.storage {
    background: url('{{ url("dist") }}/images/microsite/icon-storage-yellow.svg') no-repeat left center;
    background-size: 30px 38px;
  }

  .microsite.yellow .icon.warnings {
    background: url('{{ url("dist") }}/images/microsite/icon-warnings-yellow.svg') no-repeat left center;
    background-size: 30px 28px;
  }

  .microsite.yellow .icon.weight {
    background: url('{{ url("dist") }}/images/microsite/icon-weight-yellow.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.yellow .icon.tipandtrick {
    background: url('{{ url("dist") }}/images/microsite/icon-tiptrick-yellow.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.yellow .icon span {
    padding-top: 5px;
    color: #E4B30D;
    font-size: 22px;
    font-weight: 800;
  }

  .microsite.yellow hr {
    border-top: 1px solid #E4B30D;
  }

  .microsite.yellow .recipe {
    display: inline-block;
    border-radius: 20px;
    background-color: #E4B30D;
    padding: 8px 20px;
    margin: 20px 0;
  }


  /* green */

  .microsite.green .line {
    height: 25px;
    background-color: #B2B74D;
    display: block;
  }

  .microsite.green .icon.features {
    background: url('{{ url("dist") }}/images/microsite/icon-features-green.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.green .icon.ingredient {
    background: url('{{ url("dist") }}/images/microsite/icon-ingredient-green.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.green .icon.direction {
    background: url('{{ url("dist") }}/images/microsite/icon-direction-green.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.green .icon.alert {
    background: url('{{ url("dist") }}/images/microsite/icon-alert-green.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.green .icon.storage {
    background: url('{{ url("dist") }}/images/microsite/icon-storage-green.svg') no-repeat left center;
    background-size: 30px 38px;
  }

  .microsite.green .icon.warnings {
    background: url('{{ url("dist") }}/images/microsite/icon-warnings-green.svg') no-repeat left center;
    background-size: 30px 28px;
  }

  .microsite.green .icon.weight {
    background: url('{{ url("dist") }}/images/microsite/icon-weight-green.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.green .icon.tipandtrick {
    background: url('{{ url("dist") }}/images/microsite/icon-tiptrick-green.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.green .icon span {
    padding-top: 5px;
    color: #B2B74D;
    font-size: 22px;
    font-weight: 800;
  }

  .microsite.green hr {
    border-top: 1px solid #B2B74D;
  }

  .microsite.green .recipe {
    display: inline-block;
    border-radius: 20px;
    background-color: #B2B74D;
    padding: 8px 20px;
    margin: 20px 0;
  }


  /* mint */

  .microsite.mint .line {
    height: 25px;
    background-color: #4AA68F;
    display: block;
  }

  .microsite.mint .icon.features {
    background: url('{{ url("dist") }}/images/microsite/icon-features-mint.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.mint .icon.ingredient {
    background: url('{{ url("dist") }}/images/microsite/icon-ingredient-mint.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.mint .icon.direction {
    background: url('{{ url("dist") }}/images/microsite/icon-direction-mint.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.mint .icon.alert {
    background: url('{{ url("dist") }}/images/microsite/icon-alert-mint.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.mint .icon.storage {
    background: url('{{ url("dist") }}/images/microsite/icon-storage-mint.svg') no-repeat left center;
    background-size: 30px 38px;
  }

  .microsite.mint .icon.warnings {
    background: url('{{ url("dist") }}/images/microsite/icon-warnings-mint.svg') no-repeat left center;
    background-size: 30px 28px;
  }

  .microsite.mint .icon.weight {
    background: url('{{ url("dist") }}/images/microsite/icon-weight-mint.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.mint .icon.tipandtrick {
    background: url('{{ url("dist") }}/images/microsite/icon-tiptrick-mint.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.mint .icon span {
    padding-top: 5px;
    color: #4AA68F;
    font-size: 22px;
    font-weight: 800;
  }

  .microsite.mint hr {
    border-top: 1px solid #4AA68F;
  }

  .microsite.mint .recipe {
    display: inline-block;
    border-radius: 20px;
    background-color: #4AA68F;
    padding: 8px 20px;
    margin: 20px 0;
  }


  /* blue */

  .microsite.blue .line {
    height: 25px;
    background-color: #456DAC;
    display: block;
  }

  .microsite.blue .icon.features {
    background: url('{{ url("dist") }}/images/microsite/icon-features-blue.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.blue .icon.ingredient {
    background: url('{{ url("dist") }}/images/microsite/icon-ingredient-blue.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.blue .icon.direction {
    background: url('{{ url("dist") }}/images/microsite/icon-direction-blue.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.blue .icon.alert {
    background: url('{{ url("dist") }}/images/microsite/icon-alert-blue.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.blue .icon.storage {
    background: url('{{ url("dist") }}/images/microsite/icon-storage-blue.svg') no-repeat left center;
    background-size: 30px 38px;
  }

  .microsite.blue .icon.warnings {
    background: url('{{ url("dist") }}/images/microsite/icon-warnings-blue.svg') no-repeat left center;
    background-size: 30px 28px;
  }

  .microsite.blue .icon.weight {
    background: url('{{ url("dist") }}/images/microsite/icon-weight-blue.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.blue .icon.tipandtrick {
    background: url('{{ url("dist") }}/images/microsite/icon-tiptrick-blue.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.blue .icon span {
    padding-top: 5px;
    color: #456DAC;
    font-size: 22px;
    font-weight: 800;
  }

  .microsite.blue hr {
    border-top: 1px solid #456DAC;
  }

  .microsite.blue .recipe {
    display: inline-block;
    border-radius: 20px;
    background-color: #456DAC;
    padding: 8px 20px;
    margin: 20px 0;
  }

  /* darkblue */
  .microsite.darkblue .line {
    height: 25px;
    background-color: #002060;
    display: block;
  }

  .microsite.darkblue .icon.features {
    background: url('{{ url("dist") }}/images/microsite/icon-features-darkblue.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.darkblue .icon.ingredient {
    background: url('{{ url("dist") }}/images/microsite/icon-ingredient-darkblue.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.darkblue .icon.direction {
    background: url('{{ url("dist") }}/images/microsite/icon-direction-darkblue.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.darkblue .icon.alert {
    background: url('{{ url("dist") }}/images/microsite/icon-alert-darkblue.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.darkblue .icon.storage {
    background: url('{{ url("dist") }}/images/microsite/icon-storage-darkblue.svg') no-repeat left center;
    background-size: 30px 38px;
  }

  .microsite.darkblue .icon.warnings {
    background: url('{{ url("dist") }}/images/microsite/icon-warnings-darkblue.svg') no-repeat left center;
    background-size: 30px 28px;
  }

  .microsite.darkblue .icon.weight {
    background: url('{{ url("dist") }}/images/microsite/icon-weight-darkblue.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.darkblue .icon.tipandtrick {
    background: url('{{ url("dist") }}/images/microsite/icon-tiptrick-darkblue.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.darkblue .icon span {
    padding-top: 5px;
    color: #002060;
    font-size: 22px;
    font-weight: 800;
  }

  .microsite.darkblue hr {
    border-top: 1px solid #002060;
  }

  .microsite.darkblue .recipe {
    display: inline-block;
    border-radius: 20px;
    background-color: #002060;
    padding: 8px 20px;
    margin: 20px 0;
  }


  /* pink */

  .microsite.pink .line {
    height: 25px;
    background-color: #C06899;
    display: block;
  }

  .microsite.pink .icon.features {
    background: url('{{ url("dist") }}/images/microsite/icon-features-pink.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.pink .icon.ingredient {
    background: url('{{ url("dist") }}/images/microsite/icon-ingredient-pink.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.pink .icon.direction {
    background: url('{{ url("dist") }}/images/microsite/icon-direction-pink.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.pink .icon.alert {
    background: url('{{ url("dist") }}/images/microsite/icon-alert-pink.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.pink .icon.storage {
    background: url('{{ url("dist") }}/images/microsite/icon-storage-pink.svg') no-repeat left center;
    background-size: 30px 38px;
  }

  .microsite.pink .icon.warnings {
    background: url('{{ url("dist") }}/images/microsite/icon-warnings-pink.svg') no-repeat left center;
    background-size: 30px 28px;
  }

  .microsite.pink .icon.weight {
    background: url('{{ url("dist") }}/images/microsite/icon-weight-pink.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.pink .icon.tipandtrick {
    background: url('{{ url("dist") }}/images/microsite/icon-tiptrick-pink.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.pink .icon span {
    padding-top: 5px;
    color: #C06899;
    font-size: 22px;
    font-weight: 800;
  }

  .microsite.pink hr {
    border-top: 1px solid #C06899;
  }

  .microsite.pink .recipe {
    display: inline-block;
    border-radius: 20px;
    background-color: #C06899;
    padding: 8px 20px;
    margin: 20px 0;
  }

  /* purple */
  .microsite.purple .line {
    height: 25px;
    background-color: #65567A;
    display: block;
  }

  .microsite.purple .icon.features {
    background: url('{{ url("dist") }}/images/microsite/icon-features-purple.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.purple .icon.ingredient {
    background: url('{{ url("dist") }}/images/microsite/icon-ingredient-purple.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.purple .icon.direction {
    background: url('{{ url("dist") }}/images/microsite/icon-direction-purple.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.purple .icon.alert {
    background: url('{{ url("dist") }}/images/microsite/icon-alert-purple.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.purple .icon.storage {
    background: url('{{ url("dist") }}/images/microsite/icon-storage-purple.svg') no-repeat left center;
    background-size: 30px 38px;
  }

  .microsite.purple .icon.warnings {
    background: url('{{ url("dist") }}/images/microsite/icon-warnings-purple.svg') no-repeat left center;
    background-size: 30px 28px;
  }

  .microsite.purple .icon.weight {
    background: url('{{ url("dist") }}/images/microsite/icon-weight-purple.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.purple .icon.tipandtrick {
    background: url('{{ url("dist") }}/images/microsite/icon-tiptrick-purple.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.purple .icon span {
    padding-top: 5px;
    color: #65567A;
    font-size: 22px;
    font-weight: 800;
  }

  .microsite.purple hr {
    border-top: 1px solid #65567A;
  }

  .microsite.purple .recipe {
    display: inline-block;
    border-radius: 20px;
    background-color: #65567A;
    padding: 8px 20px;
    margin: 20px 0;
  }

  /* brown */
  .microsite.brown .line {
    height: 25px;
    background-color: #6C4401;
    display: block;
  }

  .microsite.brown .icon.features {
    background: url('{{ url("dist") }}/images/microsite/icon-features-brown.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.brown .icon.ingredient {
    background: url('{{ url("dist") }}/images/microsite/icon-ingredient-brown.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.brown .icon.direction {
    background: url('{{ url("dist") }}/images/microsite/icon-direction-brown.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.brown .icon.alert {
    background: url('{{ url("dist") }}/images/microsite/icon-alert-brown.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.brown .icon.storage {
    background: url('{{ url("dist") }}/images/microsite/icon-storage-brown.svg') no-repeat left center;
    background-size: 30px 38px;
  }

  .microsite.brown .icon.warnings {
    background: url('{{ url("dist") }}/images/microsite/icon-warnings-brown.svg') no-repeat left center;
    background-size: 30px 28px;
  }

  .microsite.brown .icon.weight {
    background: url('{{ url("dist") }}/images/microsite/icon-weight-brown.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.brown .icon.tipandtrick {
    background: url('{{ url("dist") }}/images/microsite/icon-tiptrick-brown.svg') no-repeat left center;
    background-size: 30px auto;
  }

  .microsite.brown .icon span {
    padding-top: 5px;
    color: #6C4401;
    font-size: 22px;
    font-weight: 800;
  }

  .microsite.brown hr {
    border-top: 1px solid #6C4401;
  }

  .microsite.brown .recipe {
    display: inline-block;
    border-radius: 20px;
    background-color: #6C4401;
    padding: 8px 20px;
    margin: 20px 0;
  }
</style>

<!--.box-body Other-->
<div class="box-body">

  @if (isset($url) && $url != '')
  <div class="form-group">
    {!! Form::label("qrCode", "QrCode", ['class' => 'col-sm-2 control-label','for'=>'qrCode']) !!}
    <div class="col-sm-5">
      <a href="{{ route('cms.products.product.download', ['id' => $product->id]) }}">
        {!! QrCode::style('round')->size(200)->errorCorrection('L')->generate($url) !!}
      </a>
      <br>
      <a href="{{ route('cms.products.product.download', ['id' => $product->id, 'type' => 'png']) }}">
        Download PNG
      </a>
    </div>
  </div>

  <div class="form-group">
    {!! Form::label("url", "Url", ['class' => 'col-sm-2 control-label','for'=>'url']) !!}
    <div class="col-sm-5">
      {!! Form::text("slug", old('slug', $url ?? ''), ['class' =>
      'form-control','placeholder'=>"",'id'=>'slug','readonly']) !!}
    </div>
  </div>
  @endif


  <div class="form-group {{ $errors->has('category_id') ? ' has-error has-feedback ' : '' }}">
    {!! Html::decode(Form::label("category_id", "Category", ['class' => 'col-sm-2 control-label','for'=>'ourBrand']))
    !!}
    <div class="col-sm-5">
      <select id="select_category_id" name="select_category_id" class="form-control" {{ (isset($action_page) &&
        $action_page=='view' )? 'disabled' :'' }}>
        @if(isset($categories) && $categories->count()>0)
        @foreach($categories as $key => $value)
        <option value="{{ $value->id }}-{{ $value->color }}" {{ (isset($product->category_id) &&
          $product->category_id==$value->id)?"selected":"" }}>{{ $value->title_th." / ".$value->title_en }}</option>
        @endforeach
        @endif
      </select>
      @if ($errors->has('category_id'))
      <span class="glyphicon glyphicon-remove form-control-feedback"></span>
      @endif
    </div>
  </div>

  <div class="form-group {{ $errors->has('brand_id') ? ' has-error has-feedback ' : '' }}">
    {!! Html::decode(Form::label("brand_id", "Brands", ['class' => 'col-sm-2 control-label','for'=>'ourBrand'])) !!}
    <div class="col-sm-5">
      <select id="brand_id" name="brand_id" class="form-control" {{ (isset($action_page) && $action_page=='view'
        )? 'disabled' :'' }}>
        @if(isset($productBrands) && $productBrands->count()>0)
        @foreach($productBrands as $key => $value)
        <option value="{{ $value->id }}" {{ (isset($product->brand_id) && $product->brand_id==$value->id)?"selected":""
          }}>{{ $value->title_th." / ".$value->title_en }}</option>
        @endforeach
        @endif
      </select>
      @if ($errors->has('brand_id'))
      <span class="glyphicon glyphicon-remove form-control-feedback"></span>
      @endif
    </div>
  </div>


  @include('layouts.web-admin.thumb',["pathFile"=>$product->pathFile ?? '',"filename"=>$product->thumb ??
  '',"action_page"=>$action_page??"create"])

  <div class="form-group {{ $errors->has('title_th') ? ' has-error has-feedback ' : '' }}">
    {!! Html::decode(Form::label("title_th", "Title TH <span style='color:#FF0000;font-size:12px'>*</span>", ['class' =>
    'col-sm-2 control-label','for'=>'title_th'])) !!}
    <div class="col-sm-5">
      {!! Form::text("title_th", old('title_th', $product->title_th ?? ''), ['class' =>
      'form-control','placeholder'=>"",'id'=>'title_th',(isset($action_page) && $action_page=="view")?"disabled":""])
      !!}
      @if ($errors->has('title_th'))
      <span class="glyphicon glyphicon-remove form-control-feedback"></span>
      @endif
    </div>
  </div>

  <div class="form-group {{ $errors->has('product_name_th') ? ' has-error has-feedback ' : '' }}">
    {!! Form::label("product_name_th", "Product Name TH", ['class' => 'col-sm-2 control-label','for'=>'title_th']) !!}
    <div class="col-sm-5">
      {!! Form::text("product_name_th", old('product_name_th', $product->product_name_th ?? ''), ['class' =>
      'form-control','placeholder'=>"",'id'=>'product_name_th',(isset($action_page) &&
      $action_page=="view")?"disabled":""]) !!}
      @if ($errors->has('product_name_th'))
      <span class="glyphicon glyphicon-remove form-control-feedback"></span>
      @endif
    </div>
  </div>

  <div class="form-group {{ $errors->has('content_th') ? ' has-error has-feedback ' : '' }}">
    {!! Form::label("content_th", "Content EN", ['class' => 'col-sm-2 control-label','for'=>'content_th']) !!}
    <div class="col-sm-5">
      <textarea id="content_th" name="content_th" class="form-control class_ckeditor">
      @if (isset($product))
        {!! $product->content_th ?? '' !!}
      @else
        <div class="icon features">
          <span>FEATURES</span>
        </div>
          <p>
            Ohgon No Aji is a rich Yakiniku Sauce with a perfect combination <br />
            of carefully selected apples, peaches and plum. <br />
            The power of fruits blended with herbs bring fresh and sweet sauce <br />
            making the meat <br />
            much tastier and addictive BBQ dipping sauce <br />
          </p>
          <p>There are 3 levels of spiciness</p>
          <p>Ebara Ohgon No Aji Mild </p>
          <p>Ebara Ohgon No Aji Medium-Hot</p>
          <p>Ebara Ohgon No Aji Hot</p>
          <hr />
          <div class="icon tipandtrick">
            <span>TIP & TRICK</span>
          </div>
          <p>Fruits (Apple, Peach, Plum), Soy Sauce, Sugar, Amino Acid Solution, <br />
            Gochujang, Doubanjian, Reduced Water Syrup, Garlic, Honey, Salt, <br />
            White Sesame, Onion Extract, Protein Hydrolyzate, Sesami Oil, <br />
            Spice (including wheat, sesame, soybean, peach and apple in a part)<br />
          </p>
          <hr />
          <div class="icon direction">
            <span>DIRECTION</span>
          </div>
          <p>For dipping or marinating red meat such as beef, pork, lamb
          </p>
          <hr />
          <div class="icon alert">
            <span>ALLERGENS ALERT</span>
          </div>
          <p>Wheat, Soy, Sesame</p>
          <hr />
          <div class="icon storage">
            <span>STORAGE</span>
          </div>
          <p>Room temperature. Avoid direct sunlight <br />
            After open, keep in refridgerator. Use as soon as possible after open</p>
          <hr />
          <div class="icon warnings">
            <span>WARNINGS/CAUTION</span>
          </div>
          <p>Shake well before use</p>
          <hr />
          <div class="icon weight">
            <span>WEIGHT</span>
          </div>
          <p>210 กรัม</p>
        @endif
      </textarea>
    </div>
  </div>


  <div class="form-group {{ $errors->has('title_en') ? ' has-error has-feedback ' : '' }}">
    {!! Html::decode(Form::label("title_en", "Title EN <span style='color:#FF0000;font-size:12px'>*</span>", ['class' =>
    'col-sm-2 control-label','for'=>'title_en'])) !!}
    <div class="col-sm-5">
      {!! Form::text("title_en", old('title_en', $product->title_en ?? ''), ['class' =>
      'form-control','placeholder'=>"",'id'=>'title_en',(isset($action_page) && $action_page=="view")?"disabled":""])
      !!}
      @if ($errors->has('title_en'))
      <span class="glyphicon glyphicon-remove form-control-feedback"></span>
      @endif
    </div>
  </div>

  <div class="form-group {{ $errors->has('product_name_en') ? ' has-error has-feedback ' : '' }}">
    {!! Form::label("product_name_en", "Product Name EN", ['class' => 'col-sm-2 control-label','for'=>'title_en']) !!}
    <div class="col-sm-5">
      {!! Form::text("product_name_en", old('product_name_en', $product->product_name_en ?? ''), ['class' =>
      'form-control','placeholder'=>"",'id'=>'product_name_en',(isset($action_page) &&
      $action_page=="view")?"disabled":""]) !!}
      @if ($errors->has('product_name_en'))
      <span class="glyphicon glyphicon-remove form-control-feedback"></span>
      @endif
    </div>
  </div>

  <div class="form-group {{ $errors->has('content_en') ? ' has-error has-feedback ' : '' }}">
    {!! Form::label("content_en", "Content EN", ['class' => 'col-sm-2 control-label','for'=>'content_en']) !!}
    <div class="col-sm-5">
      <textarea id="content_en" name="content_en" class="form-control class_ckeditor">
        @if (isset($product))
          {!! $product->content_en ?? '' !!}
        @else
          <div class="icon features">
            <span>FEATURES</span>
          </div>
          <p>
            Ohgon No Aji is a rich Yakiniku Sauce with a perfect combination <br />
            of carefully selected apples, peaches and plum. <br />
            The power of fruits blended with herbs bring fresh and sweet sauce <br />
            making the meat <br />
            much tastier and addictive BBQ dipping sauce <br />
          </p>
          <p>There are 3 levels of spiciness</p>
          <p>Ebara Ohgon No Aji Mild </p>
          <p>Ebara Ohgon No Aji Medium-Hot</p>
          <p>Ebara Ohgon No Aji Hot</p>
          <hr />
          <div class="icon ingredient">
            <span>INGREDIENT</span>
          </div>
          <p>Fruits (Apple, Peach, Plum), Soy Sauce, Sugar, Amino Acid Solution, <br />
            Gochujang, Doubanjian, Reduced Water Syrup, Garlic, Honey, Salt, <br />
            White Sesame, Onion Extract, Protein Hydrolyzate, Sesami Oil, <br />
            Spice (including wheat, sesame, soybean, peach and apple in a part)<br />
          </p>
          <hr />
          <div class="icon direction">
            <span>DIRECTION</span>
          </div>
          <p>For dipping or marinating red meat such as beef, pork, lamb
          </p>
          <hr />
          <div class="icon alert">
            <span>ALLERGENS ALERT</span>
          </div>
          <p>Wheat, Soy, Sesame</p>
          <hr />
          <div class="icon storage">
            <span>STORAGE</span>
          </div>
          <p>Room temperature. Avoid direct sunlight <br />
            After open, keep in refridgerator. Use as soon as possible after open</p>
          <hr />
          <div class="icon warnings">
            <span>WARNINGS/CAUTION</span>
          </div>
          <p>Shake well before use</p>
          <hr />
          <div class="icon weight">
            <span>WEIGHT</span>
          </div>
          <p>210 กรัม</p>
        @endif
      </textarea>
    </div>
  </div>

  @include('layouts.web-admin.thumb_album_1',["pathFile"=>$product->pathFile ?? '',"filename"=>$product->album_1 ??
  '',"action_page"=>$action_page??"create"])

  @include('layouts.web-admin.thumb_album_2',["pathFile"=>$product->pathFile ?? '',"filename"=>$product->album_2 ??
  '',"action_page"=>$action_page??"create"])

  @include('layouts.web-admin.thumb_album_3',["pathFile"=>$product->pathFile ?? '',"filename"=>$product->album_3 ??
  '',"action_page"=>$action_page??"create"])


  @include('layouts.web-admin.startEndDate',["startDate"=>$product->startDate ?? '',"endDate"=>$product->endDate ??
  '',"action_page"=>$action_page??"create"])

  @include('layouts.web-admin.status',["status"=>$product->status ?? 'Active',"action_page"=>$action_page??"create"])


  <div class="form-group hidden">
    {!! Form::label("order_by", "Order", ['class' => 'col-sm-2 control-label','for'=>'order_by']) !!}
    <div class="col-sm-5">
      @if (isset($action_page) && $action_page=="view")
      {!! Form::text("order_by", null, ['class' => 'form-control','placeholder'=>"0",'readonly'=>true]) !!}
      @else
      {!! Form::text("order_by", $arr_data["order_by"], ['class' => 'form-control','placeholder'=>"0",'readonly'=>true])
      !!}
      @endif
    </div>
  </div>


</div>

<input type="hidden" id="created_by" name="created_by" value="{{ \Auth::user()->id ?? '0' }}">
<input type="hidden" id="updated_by" name="updated_by" value="{{ \Auth::user()->id ?? '0' }}">
<!-- /.box-body Other-->

<div class="box-footer">
  <div class="form-group">
    <div class="col-sm-2">&nbsp;</div>
    <div class="col-sm-7">
      @if (isset($action_page) && $action_page=="view")
      <button type="button" onclick="location='{{ route('cms.products.product.index') }}'"
        class="btn btn-primary width-100 m-r-5">
        << Back</button> @else {!! Form::button($submitButtonText, ['class'=>'btn btn-success width-100
          m-r-5','onClick'=>'onSubmit()']) !!}
          <button type="button" onclick="location='{{ Route('cms.products.product.index') }}'"
            class="btn btn-default width-100 m-r-5">Cancel</button>
          @endif
    </div>
  </div>
</div>


<input type="hidden" id="category_id" name="category_id" value="{{ $product->category_id ?? 1 }}">
<!-- <input type="hidden" id="content_th" name="content_th" value="{{ $product->content_th ?? '' }}"> -->
<!-- <input type="hidden" id="content_en" name="content_en" value="{{ $product->content_en ?? '' }}"> -->


<!-- /.box-footer -->

<script type="text/javascript">
  $('document').ready(function() {
    $('#select_category_id').change(function() {
      $('.divContent .microsite').removeClass('red');
      $('.divContent .microsite').removeClass('orange');
      $('.divContent .microsite').removeClass('yellow');
      $('.divContent .microsite').removeClass('green');
      $('.divContent .microsite').removeClass('mint');
      $('.divContent .microsite').removeClass('blue');
      $('.divContent .microsite').removeClass('pink');
      $('.divContent .microsite').removeClass('brown');
      $('.divContent .microsite').removeClass('darkblue');

      var splitCatId = $(this).val().split('-');
      if (splitCatId && splitCatId.length == 2) {
        $('.divContent .microsite').addClass(splitCatId[1]);
        $('#category_id').val(splitCatId[0]);
      }
    });

    // $('#title_th').keyup(function() {
    //   $('#divContentTh .text-title strong').html($(this).val());
    // });

    // $('#title_en').keyup(function() {
    //   $('#divContentEn .text-title strong').html($(this).val());
    // });

    // $('#product_name_th').keyup(function() {
    //   $('#divContentTh .product-name').html($(this).val());
    // });

    // $('#product_name_en').keyup(function() {
    //   $('#divContentEn .product-name').html($(this).val());
    // });
  })
</script>