<?php

/*

|--------------------------------------------------------------------------

| Web Routes

|--------------------------------------------------------------------------

|

| Here is where you can register web routes for your application. These

| routes are loaded by the RouteServiceProvider within a group which

| contains the "web" middleware group. Now create something great!

|

*/
    Route::any('/sendContact', 'Front\HomeController@sendContact')->name('front.sendContact');
    Route::get('/thank-you', 'Front\HomeController@thankyou')->name('thankyou');
    Route::get('/', 'Front\HomeController@index')->name('home');
    Route::get('/ourBrands', 'Front\OurBrandsController@index')->name('ourBrands');
    Route::get('/brands', 'Front\BrandsController@index')->name('brands');
    // Route::get('/brands', 'Front\BrandsController@index')->name('brands');
    Route::get('/brook', 'Front\BrookController@index')->name('brook');
    Route::get('/mica', 'Front\MicaController@index')->name('mica');
    Route::get('/obun', 'Front\BrandsController@obun')->name('obun');
    Route::get('/nakao', 'Front\BrandsController@nakao')->name('nakao');
    Route::get('/hahne', 'Front\HahneController@index')->name('hahne');
    Route::get('/cremello', 'Front\BrandsController@cremello')->name('cremello');
    Route::get('/glodenjim', 'Front\BrandsController@glodenjim')->name('glodenjim');
    //Route::post('/checkCaptcha', 'Front\HomeController@checkCaptcha')->name('front.checkCaptcha');
    Route::get('/microsite', 'Front\MicrositeController@index')->name('microsite');

    Route::any('captcha-test', function () {
        if (request()->getMethod() == 'POST') {
            $rules = ['captcha' => 'required|captcha'];
            $validator = validator()->make(request()->all(), $rules);
            if ($validator->fails()) {
                echo '<p style="color: #ff0000;">Incorrect!</p>';
            } else {
                echo '<p style="color: #00ff30;">Matched :)</p>';
            }
        }

        $form = '<form method="post" action="captcha-test">';
        $form .= '<input type="hidden" name="_token" value="'.csrf_token().'">';
        $form .= '<p>'.captcha_img().'</p>';
        $form .= '<p><input type="text" name="captcha"></p>';
        $form .= '<p><button type="submit" name="check">Check</button></p>';
        $form .= '</form>';

        return $form;
    });

    Route::get('logs', '\Rap2hpoutre\LaravelLogViewer\LogViewerController@index');

    /*Back end*/
    // Auth::routes();
    Route::get('cms-login', 'Auth\LoginController@showLoginForm')->name('login');
    Route::post('cms-login', 'Auth\LoginController@login');
    Route::post('cms-logout', 'Auth\LoginController@logout')->name('logout');

    Route::group(['prefix' => config('config.config_pathCms'), 'as' => 'cms.', 'middleware' => ['web', 'auth:web']], function () {
        /*Products*/

        Route::get('/', 'Webadmin\DashboardController@index')->name('dashboard');

        //Products
        Route::group(['prefix' => '/products', 'as' => 'products.', 'middleware' => ['web', 'auth:web']], function () {

            Route::group(['prefix' => '/brand', 'as' => 'brand.', 'middleware' => ['web', 'auth:web']], function () {
                Route::group(['middleware' => ['web', 'auth:web', 'permission:create-productBrands']], function () {
                    Route::get('/create', 'Webadmin\ProductBrandsController@create')->name('create');
                    Route::post('/', 'Webadmin\ProductBrandsController@store')->name('store');
                });

                Route::group(['middleware' => ['web', 'auth:web', 'permission:edit-productBrands']], function () {
                    Route::post('/deleteAllSubContent', 'Webadmin\ProductBrandsController@deleteAllSubContent')->name('deleteAllSubContent');
                    Route::get('/{id}/edit', 'Webadmin\ProductBrandsController@edit')->name('edit');
                    Route::patch('/{id}', 'Webadmin\ProductBrandsController@update')->name('update');
                    Route::delete('/{id}', 'Webadmin\ProductBrandsController@destroy')->name('destroy');
                });

                Route::group(['middleware' => ['web', 'auth:web', 'permission:view-productBrands-list']], function () {
                    Route::get('/download/{id}', 'Webadmin\ProductBrandsController@download')->name('download');
                    Route::get('/{id}', 'Webadmin\ProductBrandsController@show')->name('show');
                    Route::get('/', 'Webadmin\ProductBrandsController@index')->name('indexProcess');
                    Route::get('/{orderBy?}/{ascdesc?}/{search?}', 'Webadmin\ProductBrandsController@index')->name('index');
                });
            });

            Route::group(['prefix' => '/product', 'as' => 'product.', 'middleware' => ['web', 'auth:web']], function () {
                Route::group(['middleware' => ['web', 'auth:web', 'permission:create-products']], function () {
                    Route::get('/create', 'Webadmin\ProductsController@create')->name('create');
                    Route::post('/', 'Webadmin\ProductsController@store')->name('store');
                });

                Route::group(['middleware' => ['web', 'auth:web', 'permission:edit-products']], function () {
                    Route::post('/deleteAllSubContent', 'Webadmin\ProductsController@deleteAllSubContent')->name('deleteAllSubContent');
                    Route::get('/{id}/edit', 'Webadmin\ProductsController@edit')->name('edit');
                    Route::patch('/{id}', 'Webadmin\ProductsController@update')->name('update');
                    Route::delete('/{id}', 'Webadmin\ProductsController@destroy')->name('destroy');
                });

                Route::group(['middleware' => ['web', 'auth:web', 'permission:view-products-list']], function () {
                    Route::get('/download/{id}', 'Webadmin\ProductsController@download')->name('download');
                    Route::get('/{id}', 'Webadmin\ProductsController@show')->name('show');
                    Route::get('/', 'Webadmin\ProductsController@index')->name('indexProcess');
                    Route::get('/{orderBy?}/{ascdesc?}/{search?}', 'Webadmin\ProductsController@index')->name('index');
                });
            });
        });

        /*Users*/
        Route::group(['prefix' => '/users', 'as' => 'users.', 'middleware' => ['web', 'auth:web', 'permission:view-user-list']], function () {
            Route::group(['prefix' => '/user', 'as' => 'user.'], function () {
                Route::group(['middleware' => ['web', 'auth:web', 'permission:create-user']], function () {
                    Route::get('/create', 'Webadmin\UserController@create')->name('create');
                    Route::post('/', 'Webadmin\UserController@store')->name('store');
                });

                Route::group(['middleware' => ['web', 'auth:web', 'permission:edit-user']], function () {
                    Route::get('/{id}/edit', 'Webadmin\UserController@edit')->name('edit');
                    Route::put('/{id}', 'Webadmin\UserController@update')->name('update');
                    Route::delete('/{id}', 'Webadmin\UserController@destroy')->name('destroy');
                });

                Route::group(['middleware' => ['web', 'auth:web', 'permission:view-user-list']], function () {
                    Route::get('/', 'Webadmin\UserController@index')->name('index');
                    Route::get('/{id}', 'Webadmin\UserController@show')->name('show');
                });
            });

            Route::group(['prefix' => '/role', 'as' => 'role.'], function () {
                Route::group(['middleware' => ['web', 'auth:web', 'permission:create-role']], function () {
                    Route::get('/create', 'Webadmin\RoleController@create')->name('create');
                    Route::post('/', 'Webadmin\RoleController@store')->name('store');
                });

                Route::group(['middleware' => ['web', 'auth:web', 'permission:edit-role']], function () {
                    Route::get('/{id}/edit', 'Webadmin\RoleController@edit')->name('edit');
                    Route::put('/{id}', 'Webadmin\RoleController@update')->name('update');
                    Route::delete('/{id}', 'Webadmin\RoleController@destroy')->name('destroy');
                });

                Route::group(['middleware' => ['web', 'auth:web', 'permission:view-role-list']], function () {
                    Route::get('/', 'Webadmin\RoleController@index')->name('index');
                    Route::get('/{id}', 'Webadmin\RoleController@show')->name('show');
                });
            });
        });
        /*Users*/

        //Banners
        Route::group(['prefix' => '/banners', 'as' => 'banners.', 'middleware' => ['web', 'auth:web']], function () {
            Route::group(['middleware' => ['web', 'auth:web', 'permission:create-banners']], function () {
                Route::get('/create', 'Webadmin\BannersController@create')->name('create');
                Route::post('/', 'Webadmin\BannersController@store')->name('store');
            });

            Route::group(['middleware' => ['web', 'auth:web', 'permission:edit-banners']], function () {
                Route::post('/deleteAllSubContent', 'Webadmin\BannersController@deleteAllSubContent')->name('deleteAllSubContent');
                Route::get('/{id}/edit', 'Webadmin\BannersController@edit')->name('edit');
                Route::patch('/{id}', 'Webadmin\BannersController@update')->name('update');
                Route::delete('/{id}', 'Webadmin\BannersController@destroy')->name('destroy');
            });

            Route::group(['middleware' => ['web', 'auth:web', 'permission:view-banners-list']], function () {
                Route::get('/{id}', 'Webadmin\BannersController@show')->name('show');
                Route::get('/', 'Webadmin\BannersController@index')->name('indexProcess');
                Route::get('/{orderBy?}/{ascdesc?}/{search?}', 'Webadmin\BannersController@index')->name('index');
            });
        });

        //ourBrands
        Route::group(['prefix' => '/ourBrands', 'as' => 'ourBrands.', 'middleware' => ['web', 'auth:web']], function () {
            Route::group(['middleware' => ['web', 'auth:web', 'permission:create-ourBrands']], function () {
                Route::get('/create', 'Webadmin\OurBrandsController@create')->name('create');
                Route::post('/', 'Webadmin\OurBrandsController@store')->name('store');
            });

            Route::group(['middleware' => ['web', 'auth:web', 'permission:edit-ourBrands']], function () {
                Route::post('/deleteAllSubContent', 'Webadmin\OurBrandsController@deleteAllSubContent')->name('deleteAllSubContent');
                Route::get('/{id}/edit', 'Webadmin\OurBrandsController@edit')->name('edit');
                Route::patch('/{id}', 'Webadmin\OurBrandsController@update')->name('update');
                Route::delete('/{id}', 'Webadmin\OurBrandsController@destroy')->name('destroy');
            });

            Route::group(['middleware' => ['web', 'auth:web', 'permission:view-ourBrands-list']], function () {
                Route::get('/{id}', 'Webadmin\OurBrandsController@show')->name('show');
                Route::get('/', 'Webadmin\OurBrandsController@index')->name('indexProcess');
                Route::get('/{orderBy?}/{ascdesc?}/{search?}', 'Webadmin\OurBrandsController@index')->name('index');
            });
        });


        // Route::group(['prefix' => '/contents',  'middleware' => ['web', 'auth:web']], function () {
        //     //brooks
        //     Route::group(['prefix' => '/brooks', 'as' => 'brooks.', 'middleware' => ['web', 'auth:web']], function () {
        //         Route::group(['middleware' => ['web', 'auth:web', 'permission:create-brooks']], function () {
        //             Route::get('/create', 'Webadmin\BrooksController@create')->name('create');
        //             Route::post('/', 'Webadmin\BrooksController@store')->name('store');
        //         });

        //         Route::group(['middleware' => ['web', 'auth:web', 'permission:edit-brooks']], function () {
        //             Route::post('/deleteAllSubContent', 'Webadmin\BrooksController@deleteAllSubContent')->name('deleteAllSubContent');
        //             Route::get('/{id}/edit', 'Webadmin\BrooksController@edit')->name('edit');
        //             Route::patch('/{id}', 'Webadmin\BrooksController@update')->name('update');
        //             Route::delete('/{id}', 'Webadmin\BrooksController@destroy')->name('destroy');
        //         });

        //         Route::group(['middleware' => ['web', 'auth:web', 'permission:view-brooks-list']], function () {
        //             Route::get('/{id}', 'Webadmin\BrooksController@show')->name('show');
        //             Route::get('/', 'Webadmin\BrooksController@index')->name('indexProcess');
        //             Route::get('/{orderBy?}/{ascdesc?}/{search?}', 'Webadmin\BrooksController@index')->name('index');
        //         });
        //     });

        //     //micas
        //     Route::group(['prefix' => '/micas', 'as' => 'micas.', 'middleware' => ['web', 'auth:web']], function () {
        //         Route::group(['middleware' => ['web', 'auth:web', 'permission:create-micas']], function () {
        //             Route::get('/create', 'Webadmin\MicasController@create')->name('create');
        //             Route::post('/', 'Webadmin\MicasController@store')->name('store');
        //         });

        //         Route::group(['middleware' => ['web', 'auth:web', 'permission:edit-micas']], function () {
        //             Route::post('/deleteAllSubContent', 'Webadmin\MicasController@deleteAllSubContent')->name('deleteAllSubContent');
        //             Route::get('/{id}/edit', 'Webadmin\MicasController@edit')->name('edit');
        //             Route::patch('/{id}', 'Webadmin\MicasController@update')->name('update');
        //             Route::delete('/{id}', 'Webadmin\MicasController@destroy')->name('destroy');
        //         });

        //         Route::group(['middleware' => ['web', 'auth:web', 'permission:view-micas-list']], function () {
        //             Route::get('/{id}', 'Webadmin\MicasController@show')->name('show');
        //             Route::get('/', 'Webadmin\MicasController@index')->name('indexProcess');
        //             Route::get('/{orderBy?}/{ascdesc?}/{search?}', 'Webadmin\MicasController@index')->name('index');
        //         });
        //     });

        //     //hahnes
        //     Route::group(['prefix' => '/hahnes', 'as' => 'hahnes.', 'middleware' => ['web', 'auth:web']], function () {
        //         Route::group(['middleware' => ['web', 'auth:web', 'permission:create-hahnes']], function () {
        //             Route::get('/create', 'Webadmin\HahnesController@create')->name('create');
        //             Route::post('/', 'Webadmin\HahnesController@store')->name('store');
        //         });

        //         Route::group(['middleware' => ['web', 'auth:web', 'permission:edit-hahnes']], function () {
        //             Route::post('/deleteAllSubContent', 'Webadmin\HahnesController@deleteAllSubContent')->name('deleteAllSubContent');
        //             Route::get('/{id}/edit', 'Webadmin\HahnesController@edit')->name('edit');
        //             Route::patch('/{id}', 'Webadmin\HahnesController@update')->name('update');
        //             Route::delete('/{id}', 'Webadmin\HahnesController@destroy')->name('destroy');
        //         });

        //         Route::group(['middleware' => ['web', 'auth:web', 'permission:view-hahnes-list']], function () {
        //             Route::get('/{id}', 'Webadmin\HahnesController@show')->name('show');
        //             Route::get('/', 'Webadmin\HahnesController@index')->name('indexProcess');
        //             Route::get('/{orderBy?}/{ascdesc?}/{search?}', 'Webadmin\HahnesController@index')->name('index');
        //         });
        //     });
        // });

        //Contents
        Route::group(['prefix' => '/contents', 'as' => 'contents.', 'middleware' => ['web', 'auth:web']], function () {
            Route::group(['middleware' => ['web', 'auth:web', 'permission:create-brands']], function () {
                Route::get('/create', 'Webadmin\ContentsController@create')->name('create');
                Route::post('/', 'Webadmin\ContentsController@store')->name('store');
            });

            Route::group(['middleware' => ['web', 'auth:web', 'permission:edit-brands']], function () {
                Route::post('/deleteAllSubContent', 'Webadmin\ContentsController@deleteAllSubContent')->name('deleteAllSubContent');
                Route::get('/{id}/edit', 'Webadmin\ContentsController@edit')->name('edit');
                Route::patch('/{id}', 'Webadmin\ContentsController@update')->name('update');
                Route::delete('/{id}', 'Webadmin\ContentsController@destroy')->name('destroy');
            });

            Route::group(['middleware' => ['web', 'auth:web', 'permission:view-brands-list']], function () {
                Route::get('/{id}', 'Webadmin\ContentsController@show')->name('show');
                Route::get('/', 'Webadmin\ContentsController@index')->name('indexProcess');
                Route::get('/{orderBy?}/{ascdesc?}/{search?}', 'Webadmin\ContentsController@index')->name('index');
            });
        });

        //Brands
        Route::group(['prefix' => '/brands', 'as' => 'brands.', 'middleware' => ['web', 'auth:web']], function () {
            Route::group(['middleware' => ['web', 'auth:web', 'permission:create-brands']], function () {
                Route::get('/create', 'Webadmin\BrandsController@create')->name('create');
                Route::post('/', 'Webadmin\BrandsController@store')->name('store');
            });

            Route::group(['middleware' => ['web', 'auth:web', 'permission:edit-brands']], function () {
                Route::post('/deleteAllSubContent', 'Webadmin\BrandsController@deleteAllSubContent')->name('deleteAllSubContent');
                Route::get('/{id}/edit', 'Webadmin\BrandsController@edit')->name('edit');
                Route::patch('/{id}', 'Webadmin\BrandsController@update')->name('update');
                Route::delete('/{id}', 'Webadmin\BrandsController@destroy')->name('destroy');
            });

            Route::group(['middleware' => ['web', 'auth:web', 'permission:view-brands-list']], function () {
                Route::get('/{id}', 'Webadmin\BrandsController@show')->name('show');
                Route::get('/', 'Webadmin\BrandsController@index')->name('indexProcess');
                Route::get('/{orderBy?}/{ascdesc?}/{search?}', 'Webadmin\BrandsController@index')->name('index');
            });
        });


        /*-----processdata-------*/
        Route::group(['prefix' => '/processdata'], function () {
            Route::post('/changeLimitPage', 'Webadmin\ProcessdataController@changeLimitPage');
            Route::post('/changeStatus', 'Webadmin\ProcessdataController@changeStatus');
            Route::post('/sortableData', 'Webadmin\ProcessdataController@sortableData');
            Route::post('/sortableSlideData', 'Webadmin\ProcessdataController@sortableSlideData');
            Route::post('/deleteFileData', 'Webadmin\ProcessdataController@deleteFileData');
            Route::post('/deleteThumb', 'Webadmin\ProcessdataController@deleteThumb');
            Route::post('/deleteBanner', 'Webadmin\ProcessdataController@deleteBanner');
            Route::post('/deleteBannerMulti', 'Webadmin\ProcessdataController@deleteBannerMulti');
            Route::post('/changeOrderAlbum', 'Webadmin\ProcessdataController@changeOrderAlbum');
            Route::post('/changeOrderDetail', 'Webadmin\ProcessdataController@changeOrderDetail');
            Route::post('/uploadAlbum/{page}', 'Webadmin\ProcessdataController@uploadFileAlbum');
            Route::post('/deleteAlbum/{page}', 'Webadmin\ProcessdataController@deleteFileAlbum');
            Route::post('/deleteAllData', 'Webadmin\ProcessdataController@deleteAllData');
            Route::post('/deleteAlbumAllData', 'Webadmin\ProcessdataController@deleteAlbumAllData');
            Route::post('/slugurl', 'Webadmin\ProcessdataController@slugurl');
            Route::post('/deleteItem', 'Webadmin\ProcessdataController@deleteItem');
        });
        /*-----processdata-------*/
    });


    // Route::get('/{catSlug}/{brandSlug}/{productSlug}', 'Front\MicrositeController@index')->name('product');
    Route::get('/{catSlug}/{brandSlug}/{productSlug}', 'Front\MicrositeController@index')->name('product');