<?php $__env->startSection('page_title', 'Users'); ?>
<?php $__env->startSection('page_action', 'List Data'); ?>
<?php $__env->startSection('menu_active_users',' active '); ?>
<?php $__env->startSection('submenu_active_user',' active '); ?>

<?php $__env->startSection('page_nav'); ?>
<li><a href="<?php echo e(Route('cms.users.user.index')); ?>">Users</a></li>
<li class="active">List Data</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_style'); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->



<section class="section-container section-with-top-border p-b-5">



  <?php echo $__env->make('layouts.web-admin.massage_block', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



  <div class="row">

    <div class="col-md-12">



      <!-- begin panel -->

      <div class="panel">

        <div class="panel-heading">

          <h4 class="panel-title">

            Total number of Users : <?php echo e($users_db->total()); ?>


            <?php if($hasPermission["create-user"]): ?>

            &nbsp;&nbsp;

            <a href="javascript:void(0)" onclick="location='<?php echo e(Route('cms.users.user.create')); ?>'"
              class="btn btn-xs btn-icon btn-circle btn-grey" data-click="panel-collapse" title="Add Data"><i
                class="fa fa-plus"></i></a>

            <?php endif; ?>

          </h4>



        </div>



        <div class="clear"></div>



        <div id="data-table_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">

          <table id="tbl_dataList" rel="users"
            class="table table-bordered table-hover dataTable no-footer dtr-inline table-responsive">

            <thead>

              <tr>

                <th style="width: 29%">Username</th>

                <th style="width: 24%">Email</th>

                <th style="width: 6%">Status</th>

                <th style="width: 14%">Modified</th>

                <th class="text-center" style="width: 27%">Process</th>

              </tr>

            </thead>

            <tbody>

              <?php if($users_db->count()>0): ?>

              <?php $__currentLoopData = $users_db; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

              <tr>

                <td><?php echo e($user->username); ?></td>

                <td><?php echo e($user->email); ?></td>

                <td>

                  <?php if($user->status==="Y"): ?>

                  <a id="btn_statusDataActive-<?php echo e($user->id); ?>" href="javascript:void(0)"
                    onclick="js_changeStatus('users',<?php echo e($user->id); ?>,'Y')"
                    class="btn btn-success btn-xs btn-rounded p-l-10 p-r-10">
                    <?php echo e(config('config.config_arr_status')["Y"]); ?></a>



                  <a id="btn_statusDataInactive-<?php echo e($user->id); ?>" href="javascript:void(0)"
                    onclick="js_changeStatus('users',<?php echo e($user->id); ?>,'N')"
                    class="btn btn-danger btn-xs btn-rounded p-l-10 p-r-10 hide">
                    <?php echo e(config('config.config_arr_status')["N"]); ?></a>



                  <?php else: ?>

                  <a id="btn_statusDataActive-<?php echo e($user->id); ?>" href="javascript:void(0)"
                    onclick="js_changeStatus('users',<?php echo e($user->id); ?>,'Y')"
                    class="btn btn-success btn-xs btn-rounded p-l-10 p-r-10 hide">
                    <?php echo e(config('config.config_arr_status')["Y"]); ?></a>



                  <a id="btn_statusDataInactive-<?php echo e($user->id); ?>" href="javascript:void(0)"
                    onclick="js_changeStatus('users',<?php echo e($user->id); ?>,'N')"
                    class="btn btn-danger btn-xs btn-rounded p-l-10 p-r-10 ">
                    <?php echo e(config('config.config_arr_status')["N"]); ?></a>

                  <?php endif; ?>

                </td>

                <td><?php echo e(\Carbon\Carbon::parse($user->updated_at)->diffForHumans()); ?></td>

                <td>

                  <a href="<?php echo e(Route('cms.users.user.show',['id'=>$user->id])); ?>"
                    class="btn btn-default btn-xs btn-rounded p-l-10 p-r-10"><i class="fa fa-fw fa-play"></i> View</a>

                  <?php if($hasPermission["edit-user"]): ?>

                  <a href="<?php echo e(Route('cms.users.user.edit',['id'=>$user->id])); ?>"
                    class="btn btn-default btn-xs btn-rounded p-l-10 p-r-10"><i class="fa fa-fw fa-edit"></i> Edit</a>

                  <a href="javascript:void(0)" onclick="js_deleteContent('users/user','<?php echo e($user->id); ?>')"
                    class="btn btn-danger btn-xs btn-rounded p-l-10 p-r-10"><i class="fa fa-fw fa-trash"></i> Delete</a>

                  <?php endif; ?>

                </td>

              </tr>

              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

              <?php else: ?>

              <tr>
                <td colspan="5" class="text-red text-center">--No Data--</td>
              </tr>

              <?php endif; ?>

            </tbody>

          </table>

        </div>

      </div>

      <!-- end panel -->



    </div>

    <!-- /.col -->

  </div>

  <!-- /.row -->

</section>

<!-- /.content -->



<?php $__env->stopSection(); ?>





<?php $__env->startSection('page_script'); ?>

<?php echo Html::script('js/functionjs.js'); ?>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.web-admin.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cp885822/public_html/jrfnb.co.th/resources/views/web-admin/users/index.blade.php ENDPATH**/ ?>